/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.UsageRecord;
import org.joda.time.DateTime;

public class UsageRecordReader
extends Reader<UsageRecord> {
    private String sim;
    private String fleet;
    private String network;
    private String isoCountry;
    private UsageRecord.Group group;
    private UsageRecord.Granularity granularity;
    private DateTime startTime;
    private DateTime endTime;

    public UsageRecordReader setSim(String sim) {
        this.sim = sim;
        return this;
    }

    public UsageRecordReader setFleet(String fleet) {
        this.fleet = fleet;
        return this;
    }

    public UsageRecordReader setNetwork(String network) {
        this.network = network;
        return this;
    }

    public UsageRecordReader setIsoCountry(String isoCountry) {
        this.isoCountry = isoCountry;
        return this;
    }

    public UsageRecordReader setGroup(UsageRecord.Group group) {
        this.group = group;
        return this;
    }

    public UsageRecordReader setGranularity(UsageRecord.Granularity granularity) {
        this.granularity = granularity;
        return this;
    }

    public UsageRecordReader setStartTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public UsageRecordReader setEndTime(DateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Override
    public ResourceSet<UsageRecord> read(TwilioRestClient client) {
        return new ResourceSet<UsageRecord>(this, client, this.firstPage(client));
    }

    @Override
    public Page<UsageRecord> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), "/v1/UsageRecords");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UsageRecord> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UsageRecord> nextPage(Page<UsageRecord> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UsageRecord> previousPage(Page<UsageRecord> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<UsageRecord> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UsageRecord read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("usage_records", response.getContent(), UsageRecord.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.sim != null) {
            request.addQueryParam("Sim", this.sim.toString());
        }
        if (this.fleet != null) {
            request.addQueryParam("Fleet", this.fleet.toString());
        }
        if (this.network != null) {
            request.addQueryParam("Network", this.network);
        }
        if (this.isoCountry != null) {
            request.addQueryParam("IsoCountry", this.isoCountry);
        }
        if (this.group != null) {
            request.addQueryParam("Group", this.group.toString());
        }
        if (this.granularity != null) {
            request.addQueryParam("Granularity", this.granularity.toString());
        }
        if (this.startTime != null) {
            request.addQueryParam("StartTime", this.startTime.toString());
        }
        if (this.endTime != null) {
            request.addQueryParam("EndTime", this.endTime.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

