/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.Fleet;
import java.net.URI;

public class FleetCreator
extends Creator<Fleet> {
    private final String networkAccessProfile;
    private String uniqueName;
    private Boolean dataEnabled;
    private Integer dataLimit;
    private Boolean commandsEnabled;
    private URI commandsUrl;
    private HttpMethod commandsMethod;

    public FleetCreator(String networkAccessProfile) {
        this.networkAccessProfile = networkAccessProfile;
    }

    public FleetCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public FleetCreator setDataEnabled(Boolean dataEnabled) {
        this.dataEnabled = dataEnabled;
        return this;
    }

    public FleetCreator setDataLimit(Integer dataLimit) {
        this.dataLimit = dataLimit;
        return this;
    }

    public FleetCreator setCommandsEnabled(Boolean commandsEnabled) {
        this.commandsEnabled = commandsEnabled;
        return this;
    }

    public FleetCreator setCommandsUrl(URI commandsUrl) {
        this.commandsUrl = commandsUrl;
        return this;
    }

    public FleetCreator setCommandsUrl(String commandsUrl) {
        return this.setCommandsUrl(Promoter.uriFromString(commandsUrl));
    }

    public FleetCreator setCommandsMethod(HttpMethod commandsMethod) {
        this.commandsMethod = commandsMethod;
        return this;
    }

    @Override
    public Fleet create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), "/v1/Fleets");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Fleet creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Fleet.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.networkAccessProfile != null) {
            request.addPostParam("NetworkAccessProfile", this.networkAccessProfile.toString());
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.dataEnabled != null) {
            request.addPostParam("DataEnabled", this.dataEnabled.toString());
        }
        if (this.dataLimit != null) {
            request.addPostParam("DataLimit", this.dataLimit.toString());
        }
        if (this.commandsEnabled != null) {
            request.addPostParam("CommandsEnabled", this.commandsEnabled.toString());
        }
        if (this.commandsUrl != null) {
            request.addPostParam("CommandsUrl", this.commandsUrl.toString());
        }
        if (this.commandsMethod != null) {
            request.addPostParam("CommandsMethod", this.commandsMethod.toString());
        }
    }
}

