/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms.business.insights;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.trustedComms.business.insights.ImpressionsRate;
import org.joda.time.DateTime;

public class ImpressionsRateFetcher
extends Fetcher<ImpressionsRate> {
    private final String pathBusinessSid;
    private String brandSid;
    private String brandedChannelSid;
    private String phoneNumberSid;
    private String country;
    private DateTime start;
    private DateTime end;
    private ImpressionsRate.Intervals interval;

    public ImpressionsRateFetcher(String pathBusinessSid) {
        this.pathBusinessSid = pathBusinessSid;
    }

    public ImpressionsRateFetcher setBrandSid(String brandSid) {
        this.brandSid = brandSid;
        return this;
    }

    public ImpressionsRateFetcher setBrandedChannelSid(String brandedChannelSid) {
        this.brandedChannelSid = brandedChannelSid;
        return this;
    }

    public ImpressionsRateFetcher setPhoneNumberSid(String phoneNumberSid) {
        this.phoneNumberSid = phoneNumberSid;
        return this;
    }

    public ImpressionsRateFetcher setCountry(String country) {
        this.country = country;
        return this;
    }

    public ImpressionsRateFetcher setStart(DateTime start) {
        this.start = start;
        return this;
    }

    public ImpressionsRateFetcher setEnd(DateTime end) {
        this.end = end;
        return this;
    }

    public ImpressionsRateFetcher setInterval(ImpressionsRate.Intervals interval) {
        this.interval = interval;
        return this;
    }

    @Override
    public ImpressionsRate fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/TrustedComms/Businesses/" + this.pathBusinessSid + "/Insights/ImpressionsRate");
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ImpressionsRate fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return ImpressionsRate.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.brandSid != null) {
            request.addQueryParam("BrandSid", this.brandSid);
        }
        if (this.brandedChannelSid != null) {
            request.addQueryParam("BrandedChannelSid", this.brandedChannelSid);
        }
        if (this.phoneNumberSid != null) {
            request.addQueryParam("PhoneNumberSid", this.phoneNumberSid);
        }
        if (this.country != null) {
            request.addQueryParam("Country", this.country);
        }
        if (this.start != null) {
            request.addQueryParam("Start", this.start.toString());
        }
        if (this.end != null) {
            request.addQueryParam("End", this.end.toString());
        }
        if (this.interval != null) {
            request.addQueryParam("Interval", this.interval.toString());
        }
    }
}

