/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.notify.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.notify.v1.ServiceCreator;
import com.twilio.rest.notify.v1.ServiceDeleter;
import com.twilio.rest.notify.v1.ServiceFetcher;
import com.twilio.rest.notify.v1.ServiceReader;
import com.twilio.rest.notify.v1.ServiceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Service
extends Resource {
    private static final long serialVersionUID = 267258306183645L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String apnCredentialSid;
    private final String gcmCredentialSid;
    private final String fcmCredentialSid;
    private final String messagingServiceSid;
    private final String facebookMessengerPageId;
    private final String defaultApnNotificationProtocolVersion;
    private final String defaultGcmNotificationProtocolVersion;
    private final String defaultFcmNotificationProtocolVersion;
    private final Boolean logEnabled;
    private final URI url;
    private final Map<String, String> links;
    private final String alexaSkillId;
    private final String defaultAlexaNotificationProtocolVersion;
    private final String deliveryCallbackUrl;
    private final Boolean deliveryCallbackEnabled;

    public static ServiceCreator creator() {
        return new ServiceCreator();
    }

    public static ServiceDeleter deleter(String pathSid) {
        return new ServiceDeleter(pathSid);
    }

    public static ServiceFetcher fetcher(String pathSid) {
        return new ServiceFetcher(pathSid);
    }

    public static ServiceReader reader() {
        return new ServiceReader();
    }

    public static ServiceUpdater updater(String pathSid) {
        return new ServiceUpdater(pathSid);
    }

    public static Service fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Service)objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Service fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Service)objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Service(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="apn_credential_sid") String apnCredentialSid, @JsonProperty(value="gcm_credential_sid") String gcmCredentialSid, @JsonProperty(value="fcm_credential_sid") String fcmCredentialSid, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="facebook_messenger_page_id") String facebookMessengerPageId, @JsonProperty(value="default_apn_notification_protocol_version") String defaultApnNotificationProtocolVersion, @JsonProperty(value="default_gcm_notification_protocol_version") String defaultGcmNotificationProtocolVersion, @JsonProperty(value="default_fcm_notification_protocol_version") String defaultFcmNotificationProtocolVersion, @JsonProperty(value="log_enabled") Boolean logEnabled, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="alexa_skill_id") String alexaSkillId, @JsonProperty(value="default_alexa_notification_protocol_version") String defaultAlexaNotificationProtocolVersion, @JsonProperty(value="delivery_callback_url") String deliveryCallbackUrl, @JsonProperty(value="delivery_callback_enabled") Boolean deliveryCallbackEnabled) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.apnCredentialSid = apnCredentialSid;
        this.gcmCredentialSid = gcmCredentialSid;
        this.fcmCredentialSid = fcmCredentialSid;
        this.messagingServiceSid = messagingServiceSid;
        this.facebookMessengerPageId = facebookMessengerPageId;
        this.defaultApnNotificationProtocolVersion = defaultApnNotificationProtocolVersion;
        this.defaultGcmNotificationProtocolVersion = defaultGcmNotificationProtocolVersion;
        this.defaultFcmNotificationProtocolVersion = defaultFcmNotificationProtocolVersion;
        this.logEnabled = logEnabled;
        this.url = url;
        this.links = links;
        this.alexaSkillId = alexaSkillId;
        this.defaultAlexaNotificationProtocolVersion = defaultAlexaNotificationProtocolVersion;
        this.deliveryCallbackUrl = deliveryCallbackUrl;
        this.deliveryCallbackEnabled = deliveryCallbackEnabled;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getApnCredentialSid() {
        return this.apnCredentialSid;
    }

    public final String getGcmCredentialSid() {
        return this.gcmCredentialSid;
    }

    public final String getFcmCredentialSid() {
        return this.fcmCredentialSid;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final String getFacebookMessengerPageId() {
        return this.facebookMessengerPageId;
    }

    public final String getDefaultApnNotificationProtocolVersion() {
        return this.defaultApnNotificationProtocolVersion;
    }

    public final String getDefaultGcmNotificationProtocolVersion() {
        return this.defaultGcmNotificationProtocolVersion;
    }

    public final String getDefaultFcmNotificationProtocolVersion() {
        return this.defaultFcmNotificationProtocolVersion;
    }

    public final Boolean getLogEnabled() {
        return this.logEnabled;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final String getAlexaSkillId() {
        return this.alexaSkillId;
    }

    public final String getDefaultAlexaNotificationProtocolVersion() {
        return this.defaultAlexaNotificationProtocolVersion;
    }

    public final String getDeliveryCallbackUrl() {
        return this.deliveryCallbackUrl;
    }

    public final Boolean getDeliveryCallbackEnabled() {
        return this.deliveryCallbackEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service other = (Service)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.apnCredentialSid, other.apnCredentialSid) && Objects.equals(this.gcmCredentialSid, other.gcmCredentialSid) && Objects.equals(this.fcmCredentialSid, other.fcmCredentialSid) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.facebookMessengerPageId, other.facebookMessengerPageId) && Objects.equals(this.defaultApnNotificationProtocolVersion, other.defaultApnNotificationProtocolVersion) && Objects.equals(this.defaultGcmNotificationProtocolVersion, other.defaultGcmNotificationProtocolVersion) && Objects.equals(this.defaultFcmNotificationProtocolVersion, other.defaultFcmNotificationProtocolVersion) && Objects.equals(this.logEnabled, other.logEnabled) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links) && Objects.equals(this.alexaSkillId, other.alexaSkillId) && Objects.equals(this.defaultAlexaNotificationProtocolVersion, other.defaultAlexaNotificationProtocolVersion) && Objects.equals(this.deliveryCallbackUrl, other.deliveryCallbackUrl) && Objects.equals(this.deliveryCallbackEnabled, other.deliveryCallbackEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.friendlyName, this.dateCreated, this.dateUpdated, this.apnCredentialSid, this.gcmCredentialSid, this.fcmCredentialSid, this.messagingServiceSid, this.facebookMessengerPageId, this.defaultApnNotificationProtocolVersion, this.defaultGcmNotificationProtocolVersion, this.defaultFcmNotificationProtocolVersion, this.logEnabled, this.url, this.links, this.alexaSkillId, this.defaultAlexaNotificationProtocolVersion, this.deliveryCallbackUrl, this.deliveryCallbackEnabled);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("apnCredentialSid", (Object)this.apnCredentialSid).add("gcmCredentialSid", (Object)this.gcmCredentialSid).add("fcmCredentialSid", (Object)this.fcmCredentialSid).add("messagingServiceSid", (Object)this.messagingServiceSid).add("facebookMessengerPageId", (Object)this.facebookMessengerPageId).add("defaultApnNotificationProtocolVersion", (Object)this.defaultApnNotificationProtocolVersion).add("defaultGcmNotificationProtocolVersion", (Object)this.defaultGcmNotificationProtocolVersion).add("defaultFcmNotificationProtocolVersion", (Object)this.defaultFcmNotificationProtocolVersion).add("logEnabled", (Object)this.logEnabled).add("url", (Object)this.url).add("links", this.links).add("alexaSkillId", (Object)this.alexaSkillId).add("defaultAlexaNotificationProtocolVersion", (Object)this.defaultAlexaNotificationProtocolVersion).add("deliveryCallbackUrl", (Object)this.deliveryCallbackUrl).add("deliveryCallbackEnabled", (Object)this.deliveryCallbackEnabled).toString();
    }
}

