/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.User;

public class UserUpdater
extends Updater<User> {
    private final String pathSid;
    private String friendlyName;
    private String attributes;
    private String roleSid;

    public UserUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public UserUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public UserUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public UserUpdater setRoleSid(String roleSid) {
        this.roleSid = roleSid;
        return this;
    }

    @Override
    public User update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), "/v1/Users/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("User update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return User.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.roleSid != null) {
            request.addPostParam("RoleSid", this.roleSid);
        }
    }
}

