/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.Assistant;
import java.net.URI;
import java.util.Map;

public class AssistantCreator
extends Creator<Assistant> {
    private String friendlyName;
    private Boolean logQueries;
    private String uniqueName;
    private URI callbackUrl;
    private String callbackEvents;
    private Map<String, Object> styleSheet;
    private Map<String, Object> defaults;

    public AssistantCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AssistantCreator setLogQueries(Boolean logQueries) {
        this.logQueries = logQueries;
        return this;
    }

    public AssistantCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public AssistantCreator setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public AssistantCreator setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public AssistantCreator setCallbackEvents(String callbackEvents) {
        this.callbackEvents = callbackEvents;
        return this;
    }

    public AssistantCreator setStyleSheet(Map<String, Object> styleSheet) {
        this.styleSheet = styleSheet;
        return this;
    }

    public AssistantCreator setDefaults(Map<String, Object> defaults) {
        this.defaults = defaults;
        return this;
    }

    @Override
    public Assistant create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTOPILOT.toString(), "/v1/Assistants");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Assistant creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Assistant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.logQueries != null) {
            request.addPostParam("LogQueries", this.logQueries.toString());
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
        if (this.callbackEvents != null) {
            request.addPostParam("CallbackEvents", this.callbackEvents);
        }
        if (this.styleSheet != null) {
            request.addPostParam("StyleSheet", Converter.mapToJson(this.styleSheet));
        }
        if (this.defaults != null) {
            request.addPostParam("Defaults", Converter.mapToJson(this.defaults));
        }
    }
}

