/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.google.common.collect.Range;
import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Message;
import com.twilio.type.PhoneNumber;
import org.joda.time.DateTime;

public class MessageReader
extends Reader<Message> {
    private String pathAccountSid;
    private PhoneNumber to;
    private PhoneNumber from;
    private DateTime absoluteDateSent;
    private Range<DateTime> rangeDateSent;

    public MessageReader() {
    }

    public MessageReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public MessageReader setTo(PhoneNumber to) {
        this.to = to;
        return this;
    }

    public MessageReader setTo(String to) {
        return this.setTo(Promoter.phoneNumberFromString(to));
    }

    public MessageReader setFrom(PhoneNumber from) {
        this.from = from;
        return this;
    }

    public MessageReader setFrom(String from) {
        return this.setFrom(Promoter.phoneNumberFromString(from));
    }

    public MessageReader setDateSent(DateTime absoluteDateSent) {
        this.rangeDateSent = null;
        this.absoluteDateSent = absoluteDateSent;
        return this;
    }

    public MessageReader setDateSent(Range<DateTime> rangeDateSent) {
        this.absoluteDateSent = null;
        this.rangeDateSent = rangeDateSent;
        return this;
    }

    @Override
    public ResourceSet<Message> read(TwilioRestClient client) {
        return new ResourceSet<Message>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Message> firstPage(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Messages.json");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Message> getPage(String targetUrl, TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Message> nextPage(Page<Message> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Message> previousPage(Page<Message> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Message> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Message read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("messages", response.getContent(), Message.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.to != null) {
            request.addQueryParam("To", this.to.toString());
        }
        if (this.from != null) {
            request.addQueryParam("From", this.from.toString());
        }
        if (this.absoluteDateSent != null) {
            request.addQueryParam("DateSent", this.absoluteDateSent.toString("yyyy-MM-dd'T'HH:mm:ss"));
        } else if (this.rangeDateSent != null) {
            request.addQueryDateTimeRange("DateSent", this.rangeDateSent);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

