/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.twiml.TwiML;
import com.twilio.twiml.voice.SsmlBreak;
import com.twilio.twiml.voice.SsmlEmphasis;
import com.twilio.twiml.voice.SsmlLang;
import com.twilio.twiml.voice.SsmlP;
import com.twilio.twiml.voice.SsmlPhoneme;
import com.twilio.twiml.voice.SsmlProsody;
import com.twilio.twiml.voice.SsmlS;
import com.twilio.twiml.voice.SsmlSayAs;
import com.twilio.twiml.voice.SsmlSub;
import com.twilio.twiml.voice.SsmlW;
import java.util.HashMap;
import java.util.Map;

public class Say
extends TwiML {
    private final Voice voice;
    private final Integer loop;
    private final Language language;
    private final String message;

    private Say() {
        this(new Builder());
    }

    private Say(Builder b) {
        super("Say", b);
        this.voice = b.voice;
        this.loop = b.loop;
        this.language = b.language;
        this.message = b.message;
    }

    @Override
    protected String getElementBody() {
        return this.getMessage() == null ? null : this.getMessage();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getVoice() != null) {
            attrs.put("voice", this.getVoice().toString());
        }
        if (this.getLoop() != null) {
            attrs.put("loop", this.getLoop().toString());
        }
        if (this.getLanguage() != null) {
            attrs.put("language", this.getLanguage().toString());
        }
        return attrs;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public Integer getLoop() {
        return this.loop;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getMessage() {
        return this.message;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private Voice voice;
        private Integer loop;
        private Language language;
        private String message;

        public Builder(String message) {
            this.message = message;
        }

        public Builder() {
        }

        public Builder voice(Voice voice) {
            this.voice = voice;
            return this;
        }

        public Builder loop(Integer loop) {
            this.loop = loop;
            return this;
        }

        public Builder language(Language language) {
            this.language = language;
            return this;
        }

        public Builder break_(SsmlBreak ssmlBreak) {
            this.children.add(ssmlBreak);
            return this;
        }

        @Deprecated
        public Builder ssmlBreak(SsmlBreak ssmlBreak) {
            return this.break_(ssmlBreak);
        }

        public Builder emphasis(SsmlEmphasis ssmlEmphasis) {
            this.children.add(ssmlEmphasis);
            return this;
        }

        @Deprecated
        public Builder ssmlEmphasis(SsmlEmphasis ssmlEmphasis) {
            return this.emphasis(ssmlEmphasis);
        }

        public Builder lang(SsmlLang ssmlLang) {
            this.children.add(ssmlLang);
            return this;
        }

        @Deprecated
        public Builder ssmlLang(SsmlLang ssmlLang) {
            return this.lang(ssmlLang);
        }

        public Builder p(SsmlP ssmlP) {
            this.children.add(ssmlP);
            return this;
        }

        @Deprecated
        public Builder ssmlP(SsmlP ssmlP) {
            return this.p(ssmlP);
        }

        public Builder phoneme(SsmlPhoneme ssmlPhoneme) {
            this.children.add(ssmlPhoneme);
            return this;
        }

        @Deprecated
        public Builder ssmlPhoneme(SsmlPhoneme ssmlPhoneme) {
            return this.phoneme(ssmlPhoneme);
        }

        public Builder prosody(SsmlProsody ssmlProsody) {
            this.children.add(ssmlProsody);
            return this;
        }

        @Deprecated
        public Builder ssmlProsody(SsmlProsody ssmlProsody) {
            return this.prosody(ssmlProsody);
        }

        public Builder s(SsmlS ssmlS) {
            this.children.add(ssmlS);
            return this;
        }

        @Deprecated
        public Builder ssmlS(SsmlS ssmlS) {
            return this.s(ssmlS);
        }

        public Builder sayAs(SsmlSayAs ssmlSayAs) {
            this.children.add(ssmlSayAs);
            return this;
        }

        @Deprecated
        public Builder ssmlSayAs(SsmlSayAs ssmlSayAs) {
            return this.sayAs(ssmlSayAs);
        }

        public Builder sub(SsmlSub ssmlSub) {
            this.children.add(ssmlSub);
            return this;
        }

        @Deprecated
        public Builder ssmlSub(SsmlSub ssmlSub) {
            return this.sub(ssmlSub);
        }

        public Builder w(SsmlW ssmlW) {
            this.children.add(ssmlW);
            return this;
        }

        @Deprecated
        public Builder ssmlW(SsmlW ssmlW) {
            return this.w(ssmlW);
        }

        public Say build() {
            return new Say(this);
        }
    }

    public static enum Language {
        ARB("arb"),
        CA_ES("ca-ES"),
        CY_GB("cy-GB"),
        DA_DK("da-DK"),
        DE_DE("de-DE"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_GB("en-GB"),
        EN_GB_WLS("en-GB-WLS"),
        EN_IN("en-IN"),
        EN_US("en-US"),
        ES_ES("es-ES"),
        ES_MX("es-MX"),
        ES_US("es-US"),
        FI_FI("fi-FI"),
        FR_CA("fr-CA"),
        FR_FR("fr-FR"),
        HI_IN("hi-IN"),
        IS_IS("is-IS"),
        IT_IT("it-IT"),
        JA_JP("ja-JP"),
        KO_KR("ko-KR"),
        NB_NO("nb-NO"),
        NL_NL("nl-NL"),
        PL_PL("pl-PL"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        RO_RO("ro-RO"),
        RU_RU("ru-RU"),
        SV_SE("sv-SE"),
        TR_TR("tr-TR"),
        ZH_CN("zh-CN"),
        ZH_HK("zh-HK"),
        ZH_TW("zh-TW");

        private final String value;

        private Language(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Voice {
        MAN("man"),
        WOMAN("woman"),
        ALICE("alice"),
        POLLY_ADITI("Polly.Aditi"),
        POLLY_AMY("Polly.Amy"),
        POLLY_ASTRID("Polly.Astrid"),
        POLLY_BIANCA("Polly.Bianca"),
        POLLY_BRIAN("Polly.Brian"),
        POLLY_CAMILA("Polly.Camila"),
        POLLY_CARLA("Polly.Carla"),
        POLLY_CARMEN("Polly.Carmen"),
        POLLY_CELINE("Polly.Celine"),
        POLLY_CHANTAL("Polly.Chantal"),
        POLLY_CONCHITA("Polly.Conchita"),
        POLLY_CRISTIANO("Polly.Cristiano"),
        POLLY_DORA("Polly.Dora"),
        POLLY_EMMA("Polly.Emma"),
        POLLY_ENRIQUE("Polly.Enrique"),
        POLLY_EWA("Polly.Ewa"),
        POLLY_FILIZ("Polly.Filiz"),
        POLLY_GERAINT("Polly.Geraint"),
        POLLY_GIORGIO("Polly.Giorgio"),
        POLLY_GWYNETH("Polly.Gwyneth"),
        POLLY_HANS("Polly.Hans"),
        POLLY_INES("Polly.Ines"),
        POLLY_IVY("Polly.Ivy"),
        POLLY_JACEK("Polly.Jacek"),
        POLLY_JAN("Polly.Jan"),
        POLLY_JOANNA("Polly.Joanna"),
        POLLY_JOEY("Polly.Joey"),
        POLLY_JUSTIN("Polly.Justin"),
        POLLY_KARL("Polly.Karl"),
        POLLY_KENDRA("Polly.Kendra"),
        POLLY_KIMBERLY("Polly.Kimberly"),
        POLLY_LEA("Polly.Lea"),
        POLLY_LIV("Polly.Liv"),
        POLLY_LOTTE("Polly.Lotte"),
        POLLY_LUCIA("Polly.Lucia"),
        POLLY_LUPE("Polly.Lupe"),
        POLLY_MADS("Polly.Mads"),
        POLLY_MAJA("Polly.Maja"),
        POLLY_MARLENE("Polly.Marlene"),
        POLLY_MATHIEU("Polly.Mathieu"),
        POLLY_MATTHEW("Polly.Matthew"),
        POLLY_MAXIM("Polly.Maxim"),
        POLLY_MIA("Polly.Mia"),
        POLLY_MIGUEL("Polly.Miguel"),
        POLLY_MIZUKI("Polly.Mizuki"),
        POLLY_NAJA("Polly.Naja"),
        POLLY_NICOLE("Polly.Nicole"),
        POLLY_PENELOPE("Polly.Penelope"),
        POLLY_RAVEENA("Polly.Raveena"),
        POLLY_RICARDO("Polly.Ricardo"),
        POLLY_RUBEN("Polly.Ruben"),
        POLLY_RUSSELL("Polly.Russell"),
        POLLY_SALLI("Polly.Salli"),
        POLLY_SEOYEON("Polly.Seoyeon"),
        POLLY_TAKUMI("Polly.Takumi"),
        POLLY_TATYANA("Polly.Tatyana"),
        POLLY_VICKI("Polly.Vicki"),
        POLLY_VITORIA("Polly.Vitoria"),
        POLLY_ZEINA("Polly.Zeina"),
        POLLY_ZHIYU("Polly.Zhiyu"),
        POLLY_AMY_NEURAL("Polly.Amy-Neural"),
        POLLY_EMMA_NEURAL("Polly.Emma-Neural"),
        POLLY_BRIAN_NEURAL("Polly.Brian-Neural"),
        POLLY_SALLI_NEURAL("Polly.Salli-Neural"),
        POLLY_IVY_NEURAL("Polly.Ivy-Neural"),
        POLLY_JOANNA_NEURAL("Polly.Joanna-Neural"),
        POLLY_KENDRA_NEURAL("Polly.Kendra-Neural"),
        POLLY_KIMBERLY_NEURAL("Polly.Kimberly-Neural"),
        POLLY_JOEY_NEURAL("Polly.Joey-Neural"),
        POLLY_JUSTIN_NEURAL("Polly.Justin-Neural"),
        POLLY_MATTHEW_NEURAL("Polly.Matthew-Neural"),
        POLLY_CAMILA_NEURAL("Polly.Camila-Neural"),
        POLLY_LUPE_NEURAL("Polly.Lupe-Neural");

        private final String value;

        private Voice(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

