/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class Redirect
extends TwiML {
    private final HttpMethod method;
    private final URI url;

    private Redirect() {
        this(new Builder((URI)null));
    }

    private Redirect(Builder b) {
        super("Redirect", b);
        this.method = b.method;
        this.url = b.url;
    }

    @Override
    protected String getElementBody() {
        return this.getUrl() == null ? null : this.getUrl().toString();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        return attrs;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getUrl() {
        return this.url;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private HttpMethod method;
        private URI url;

        public Builder(URI url) {
            this.url = url;
        }

        public Builder(String url) {
            this.url = Promoter.uriFromString(url);
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Redirect build() {
            return new Redirect(this);
        }
    }
}

