/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.connectionpolicy;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.connectionpolicy.ConnectionPolicyTarget;

public class ConnectionPolicyTargetReader
extends Reader<ConnectionPolicyTarget> {
    private final String pathConnectionPolicySid;

    public ConnectionPolicyTargetReader(String pathConnectionPolicySid) {
        this.pathConnectionPolicySid = pathConnectionPolicySid;
    }

    @Override
    public ResourceSet<ConnectionPolicyTarget> read(TwilioRestClient client) {
        return new ResourceSet<ConnectionPolicyTarget>(this, client, this.firstPage(client));
    }

    @Override
    public Page<ConnectionPolicyTarget> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VOICE.toString(), "/v1/ConnectionPolicies/" + this.pathConnectionPolicySid + "/Targets");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ConnectionPolicyTarget> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ConnectionPolicyTarget> nextPage(Page<ConnectionPolicyTarget> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VOICE.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ConnectionPolicyTarget> previousPage(Page<ConnectionPolicyTarget> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VOICE.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<ConnectionPolicyTarget> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ConnectionPolicyTarget read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("targets", response.getContent(), ConnectionPolicyTarget.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

