/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.connectionpolicy;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.connectionpolicy.ConnectionPolicyTarget;

public class ConnectionPolicyTargetFetcher
extends Fetcher<ConnectionPolicyTarget> {
    private final String pathConnectionPolicySid;
    private final String pathSid;

    public ConnectionPolicyTargetFetcher(String pathConnectionPolicySid, String pathSid) {
        this.pathConnectionPolicySid = pathConnectionPolicySid;
        this.pathSid = pathSid;
    }

    @Override
    public ConnectionPolicyTarget fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VOICE.toString(), "/v1/ConnectionPolicies/" + this.pathConnectionPolicySid + "/Targets/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ConnectionPolicyTarget fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return ConnectionPolicyTarget.fromJson(response.getStream(), client.getObjectMapper());
    }
}

