/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trunking.v1.trunk.IpAccessControlListCreator;
import com.twilio.rest.trunking.v1.trunk.IpAccessControlListDeleter;
import com.twilio.rest.trunking.v1.trunk.IpAccessControlListFetcher;
import com.twilio.rest.trunking.v1.trunk.IpAccessControlListReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IpAccessControlList
extends Resource {
    private static final long serialVersionUID = 45032598628398L;
    private final String accountSid;
    private final String sid;
    private final String trunkSid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static IpAccessControlListFetcher fetcher(String pathTrunkSid, String pathSid) {
        return new IpAccessControlListFetcher(pathTrunkSid, pathSid);
    }

    public static IpAccessControlListDeleter deleter(String pathTrunkSid, String pathSid) {
        return new IpAccessControlListDeleter(pathTrunkSid, pathSid);
    }

    public static IpAccessControlListCreator creator(String pathTrunkSid, String ipAccessControlListSid) {
        return new IpAccessControlListCreator(pathTrunkSid, ipAccessControlListSid);
    }

    public static IpAccessControlListReader reader(String pathTrunkSid) {
        return new IpAccessControlListReader(pathTrunkSid);
    }

    public static IpAccessControlList fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (IpAccessControlList)objectMapper.readValue(json, IpAccessControlList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static IpAccessControlList fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (IpAccessControlList)objectMapper.readValue(json, IpAccessControlList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private IpAccessControlList(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="trunk_sid") String trunkSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.trunkSid = trunkSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTrunkSid() {
        return this.trunkSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpAccessControlList other = (IpAccessControlList)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.trunkSid, other.trunkSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.sid, this.trunkSid, this.friendlyName, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("sid", (Object)this.sid).add("trunkSid", (Object)this.trunkSid).add("friendlyName", (Object)this.friendlyName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }
}

