/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.trunking.v1.TrunkCreator;
import com.twilio.rest.trunking.v1.TrunkDeleter;
import com.twilio.rest.trunking.v1.TrunkFetcher;
import com.twilio.rest.trunking.v1.TrunkReader;
import com.twilio.rest.trunking.v1.TrunkUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Trunk
extends Resource {
    private static final long serialVersionUID = 110040442840544L;
    private final String accountSid;
    private final String domainName;
    private final HttpMethod disasterRecoveryMethod;
    private final URI disasterRecoveryUrl;
    private final String friendlyName;
    private final Boolean secure;
    private final Map<String, Object> recording;
    private final TransferSetting transferMode;
    private final Boolean cnamLookupEnabled;
    private final String authType;
    private final List<String> authTypeSet;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String sid;
    private final URI url;
    private final Map<String, String> links;

    public static TrunkFetcher fetcher(String pathSid) {
        return new TrunkFetcher(pathSid);
    }

    public static TrunkDeleter deleter(String pathSid) {
        return new TrunkDeleter(pathSid);
    }

    public static TrunkCreator creator() {
        return new TrunkCreator();
    }

    public static TrunkReader reader() {
        return new TrunkReader();
    }

    public static TrunkUpdater updater(String pathSid) {
        return new TrunkUpdater(pathSid);
    }

    public static Trunk fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Trunk)objectMapper.readValue(json, Trunk.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Trunk fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Trunk)objectMapper.readValue(json, Trunk.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Trunk(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="domain_name") String domainName, @JsonProperty(value="disaster_recovery_method") HttpMethod disasterRecoveryMethod, @JsonProperty(value="disaster_recovery_url") URI disasterRecoveryUrl, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="secure") Boolean secure, @JsonProperty(value="recording") Map<String, Object> recording, @JsonProperty(value="transfer_mode") TransferSetting transferMode, @JsonProperty(value="cnam_lookup_enabled") Boolean cnamLookupEnabled, @JsonProperty(value="auth_type") String authType, @JsonProperty(value="auth_type_set") List<String> authTypeSet, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="sid") String sid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.domainName = domainName;
        this.disasterRecoveryMethod = disasterRecoveryMethod;
        this.disasterRecoveryUrl = disasterRecoveryUrl;
        this.friendlyName = friendlyName;
        this.secure = secure;
        this.recording = recording;
        this.transferMode = transferMode;
        this.cnamLookupEnabled = cnamLookupEnabled;
        this.authType = authType;
        this.authTypeSet = authTypeSet;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.sid = sid;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getDomainName() {
        return this.domainName;
    }

    public final HttpMethod getDisasterRecoveryMethod() {
        return this.disasterRecoveryMethod;
    }

    public final URI getDisasterRecoveryUrl() {
        return this.disasterRecoveryUrl;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Boolean getSecure() {
        return this.secure;
    }

    public final Map<String, Object> getRecording() {
        return this.recording;
    }

    public final TransferSetting getTransferMode() {
        return this.transferMode;
    }

    public final Boolean getCnamLookupEnabled() {
        return this.cnamLookupEnabled;
    }

    public final String getAuthType() {
        return this.authType;
    }

    public final List<String> getAuthTypeSet() {
        return this.authTypeSet;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trunk other = (Trunk)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.domainName, other.domainName) && Objects.equals((Object)this.disasterRecoveryMethod, (Object)other.disasterRecoveryMethod) && Objects.equals(this.disasterRecoveryUrl, other.disasterRecoveryUrl) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.secure, other.secure) && Objects.equals(this.recording, other.recording) && Objects.equals((Object)this.transferMode, (Object)other.transferMode) && Objects.equals(this.cnamLookupEnabled, other.cnamLookupEnabled) && Objects.equals(this.authType, other.authType) && Objects.equals(this.authTypeSet, other.authTypeSet) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.sid, other.sid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.domainName, this.disasterRecoveryMethod, this.disasterRecoveryUrl, this.friendlyName, this.secure, this.recording, this.transferMode, this.cnamLookupEnabled, this.authType, this.authTypeSet, this.dateCreated, this.dateUpdated, this.sid, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("domainName", (Object)this.domainName).add("disasterRecoveryMethod", (Object)this.disasterRecoveryMethod).add("disasterRecoveryUrl", (Object)this.disasterRecoveryUrl).add("friendlyName", (Object)this.friendlyName).add("secure", (Object)this.secure).add("recording", this.recording).add("transferMode", (Object)this.transferMode).add("cnamLookupEnabled", (Object)this.cnamLookupEnabled).add("authType", (Object)this.authType).add("authTypeSet", this.authTypeSet).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("sid", (Object)this.sid).add("url", (Object)this.url).add("links", this.links).toString();
    }

    public static enum TransferSetting {
        DISABLE_ALL("disable-all"),
        ENABLE_ALL("enable-all"),
        SIP_ONLY("sip-only");

        private final String value;

        private TransferSetting(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TransferSetting forValue(String value) {
            return (TransferSetting)Promoter.enumFromString((String)value, (Enum[])TransferSetting.values());
        }
    }
}

