/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkersCumulativeStatistics;
import org.joda.time.DateTime;

public class WorkersCumulativeStatisticsFetcher
extends Fetcher<WorkersCumulativeStatistics> {
    private final String pathWorkspaceSid;
    private DateTime endDate;
    private Integer minutes;
    private DateTime startDate;
    private String taskChannel;

    public WorkersCumulativeStatisticsFetcher(String pathWorkspaceSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
    }

    public WorkersCumulativeStatisticsFetcher setEndDate(DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public WorkersCumulativeStatisticsFetcher setMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public WorkersCumulativeStatisticsFetcher setStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public WorkersCumulativeStatisticsFetcher setTaskChannel(String taskChannel) {
        this.taskChannel = taskChannel;
        return this;
    }

    @Override
    public WorkersCumulativeStatistics fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Workers/CumulativeStatistics");
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WorkersCumulativeStatistics fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return WorkersCumulativeStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toString());
        }
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toString());
        }
        if (this.taskChannel != null) {
            request.addQueryParam("TaskChannel", this.taskChannel);
        }
    }
}

