/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkerChannelFetcher;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkerChannelReader;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkerChannelUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkerChannel
extends Resource {
    private static final long serialVersionUID = 181596062682267L;
    private final String accountSid;
    private final Integer assignedTasks;
    private final Boolean available;
    private final Integer availableCapacityPercentage;
    private final Integer configuredCapacity;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String sid;
    private final String taskChannelSid;
    private final String taskChannelUniqueName;
    private final String workerSid;
    private final String workspaceSid;
    private final URI url;

    public static WorkerChannelReader reader(String pathWorkspaceSid, String pathWorkerSid) {
        return new WorkerChannelReader(pathWorkspaceSid, pathWorkerSid);
    }

    public static WorkerChannelFetcher fetcher(String pathWorkspaceSid, String pathWorkerSid, String pathSid) {
        return new WorkerChannelFetcher(pathWorkspaceSid, pathWorkerSid, pathSid);
    }

    public static WorkerChannelUpdater updater(String pathWorkspaceSid, String pathWorkerSid, String pathSid) {
        return new WorkerChannelUpdater(pathWorkspaceSid, pathWorkerSid, pathSid);
    }

    public static WorkerChannel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (WorkerChannel)objectMapper.readValue(json, WorkerChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkerChannel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (WorkerChannel)objectMapper.readValue(json, WorkerChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkerChannel(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="assigned_tasks") Integer assignedTasks, @JsonProperty(value="available") Boolean available, @JsonProperty(value="available_capacity_percentage") Integer availableCapacityPercentage, @JsonProperty(value="configured_capacity") Integer configuredCapacity, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="sid") String sid, @JsonProperty(value="task_channel_sid") String taskChannelSid, @JsonProperty(value="task_channel_unique_name") String taskChannelUniqueName, @JsonProperty(value="worker_sid") String workerSid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.assignedTasks = assignedTasks;
        this.available = available;
        this.availableCapacityPercentage = availableCapacityPercentage;
        this.configuredCapacity = configuredCapacity;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.sid = sid;
        this.taskChannelSid = taskChannelSid;
        this.taskChannelUniqueName = taskChannelUniqueName;
        this.workerSid = workerSid;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getAssignedTasks() {
        return this.assignedTasks;
    }

    public final Boolean getAvailable() {
        return this.available;
    }

    public final Integer getAvailableCapacityPercentage() {
        return this.availableCapacityPercentage;
    }

    public final Integer getConfiguredCapacity() {
        return this.configuredCapacity;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTaskChannelSid() {
        return this.taskChannelSid;
    }

    public final String getTaskChannelUniqueName() {
        return this.taskChannelUniqueName;
    }

    public final String getWorkerSid() {
        return this.workerSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerChannel other = (WorkerChannel)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.assignedTasks, other.assignedTasks) && Objects.equals(this.available, other.available) && Objects.equals(this.availableCapacityPercentage, other.availableCapacityPercentage) && Objects.equals(this.configuredCapacity, other.configuredCapacity) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.sid, other.sid) && Objects.equals(this.taskChannelSid, other.taskChannelSid) && Objects.equals(this.taskChannelUniqueName, other.taskChannelUniqueName) && Objects.equals(this.workerSid, other.workerSid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.assignedTasks, this.available, this.availableCapacityPercentage, this.configuredCapacity, this.dateCreated, this.dateUpdated, this.sid, this.taskChannelSid, this.taskChannelUniqueName, this.workerSid, this.workspaceSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("assignedTasks", (Object)this.assignedTasks).add("available", (Object)this.available).add("availableCapacityPercentage", (Object)this.availableCapacityPercentage).add("configuredCapacity", (Object)this.configuredCapacity).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("sid", (Object)this.sid).add("taskChannelSid", (Object)this.taskChannelSid).add("taskChannelUniqueName", (Object)this.taskChannelUniqueName).add("workerSid", (Object)this.workerSid).add("workspaceSid", (Object)this.workspaceSid).add("url", (Object)this.url).toString();
    }
}

