/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.worker.Reservation;
import java.net.URI;
import java.util.List;

public class ReservationUpdater
extends Updater<Reservation> {
    private final String pathWorkspaceSid;
    private final String pathWorkerSid;
    private final String pathSid;
    private Reservation.Status reservationStatus;
    private String workerActivitySid;
    private String instruction;
    private String dequeuePostWorkActivitySid;
    private String dequeueFrom;
    private String dequeueRecord;
    private Integer dequeueTimeout;
    private String dequeueTo;
    private URI dequeueStatusCallbackUrl;
    private String callFrom;
    private String callRecord;
    private Integer callTimeout;
    private String callTo;
    private URI callUrl;
    private URI callStatusCallbackUrl;
    private Boolean callAccept;
    private String redirectCallSid;
    private Boolean redirectAccept;
    private URI redirectUrl;
    private String to;
    private String from;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;
    private List<Reservation.CallStatus> statusCallbackEvent;
    private Integer timeout;
    private Boolean record;
    private Boolean muted;
    private String beep;
    private Boolean startConferenceOnEnter;
    private Boolean endConferenceOnExit;
    private URI waitUrl;
    private HttpMethod waitMethod;
    private Boolean earlyMedia;
    private Integer maxParticipants;
    private URI conferenceStatusCallback;
    private HttpMethod conferenceStatusCallbackMethod;
    private List<Reservation.ConferenceEvent> conferenceStatusCallbackEvent;
    private String conferenceRecord;
    private String conferenceTrim;
    private String recordingChannels;
    private URI recordingStatusCallback;
    private HttpMethod recordingStatusCallbackMethod;
    private URI conferenceRecordingStatusCallback;
    private HttpMethod conferenceRecordingStatusCallbackMethod;
    private String region;
    private String sipAuthUsername;
    private String sipAuthPassword;
    private List<String> dequeueStatusCallbackEvent;
    private String postWorkActivitySid;
    private Boolean endConferenceOnCustomerExit;
    private Boolean beepOnCustomerEntrance;

    public ReservationUpdater(String pathWorkspaceSid, String pathWorkerSid, String pathSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathWorkerSid = pathWorkerSid;
        this.pathSid = pathSid;
    }

    public ReservationUpdater setReservationStatus(Reservation.Status reservationStatus) {
        this.reservationStatus = reservationStatus;
        return this;
    }

    public ReservationUpdater setWorkerActivitySid(String workerActivitySid) {
        this.workerActivitySid = workerActivitySid;
        return this;
    }

    public ReservationUpdater setInstruction(String instruction) {
        this.instruction = instruction;
        return this;
    }

    public ReservationUpdater setDequeuePostWorkActivitySid(String dequeuePostWorkActivitySid) {
        this.dequeuePostWorkActivitySid = dequeuePostWorkActivitySid;
        return this;
    }

    public ReservationUpdater setDequeueFrom(String dequeueFrom) {
        this.dequeueFrom = dequeueFrom;
        return this;
    }

    public ReservationUpdater setDequeueRecord(String dequeueRecord) {
        this.dequeueRecord = dequeueRecord;
        return this;
    }

    public ReservationUpdater setDequeueTimeout(Integer dequeueTimeout) {
        this.dequeueTimeout = dequeueTimeout;
        return this;
    }

    public ReservationUpdater setDequeueTo(String dequeueTo) {
        this.dequeueTo = dequeueTo;
        return this;
    }

    public ReservationUpdater setDequeueStatusCallbackUrl(URI dequeueStatusCallbackUrl) {
        this.dequeueStatusCallbackUrl = dequeueStatusCallbackUrl;
        return this;
    }

    public ReservationUpdater setDequeueStatusCallbackUrl(String dequeueStatusCallbackUrl) {
        return this.setDequeueStatusCallbackUrl(Promoter.uriFromString(dequeueStatusCallbackUrl));
    }

    public ReservationUpdater setCallFrom(String callFrom) {
        this.callFrom = callFrom;
        return this;
    }

    public ReservationUpdater setCallRecord(String callRecord) {
        this.callRecord = callRecord;
        return this;
    }

    public ReservationUpdater setCallTimeout(Integer callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public ReservationUpdater setCallTo(String callTo) {
        this.callTo = callTo;
        return this;
    }

    public ReservationUpdater setCallUrl(URI callUrl) {
        this.callUrl = callUrl;
        return this;
    }

    public ReservationUpdater setCallUrl(String callUrl) {
        return this.setCallUrl(Promoter.uriFromString(callUrl));
    }

    public ReservationUpdater setCallStatusCallbackUrl(URI callStatusCallbackUrl) {
        this.callStatusCallbackUrl = callStatusCallbackUrl;
        return this;
    }

    public ReservationUpdater setCallStatusCallbackUrl(String callStatusCallbackUrl) {
        return this.setCallStatusCallbackUrl(Promoter.uriFromString(callStatusCallbackUrl));
    }

    public ReservationUpdater setCallAccept(Boolean callAccept) {
        this.callAccept = callAccept;
        return this;
    }

    public ReservationUpdater setRedirectCallSid(String redirectCallSid) {
        this.redirectCallSid = redirectCallSid;
        return this;
    }

    public ReservationUpdater setRedirectAccept(Boolean redirectAccept) {
        this.redirectAccept = redirectAccept;
        return this;
    }

    public ReservationUpdater setRedirectUrl(URI redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public ReservationUpdater setRedirectUrl(String redirectUrl) {
        return this.setRedirectUrl(Promoter.uriFromString(redirectUrl));
    }

    public ReservationUpdater setTo(String to) {
        this.to = to;
        return this;
    }

    public ReservationUpdater setFrom(String from) {
        this.from = from;
        return this;
    }

    public ReservationUpdater setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public ReservationUpdater setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public ReservationUpdater setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public ReservationUpdater setStatusCallbackEvent(List<Reservation.CallStatus> statusCallbackEvent) {
        this.statusCallbackEvent = statusCallbackEvent;
        return this;
    }

    public ReservationUpdater setStatusCallbackEvent(Reservation.CallStatus statusCallbackEvent) {
        return this.setStatusCallbackEvent(Promoter.listOfOne(statusCallbackEvent));
    }

    public ReservationUpdater setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public ReservationUpdater setRecord(Boolean record) {
        this.record = record;
        return this;
    }

    public ReservationUpdater setMuted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    public ReservationUpdater setBeep(String beep) {
        this.beep = beep;
        return this;
    }

    public ReservationUpdater setStartConferenceOnEnter(Boolean startConferenceOnEnter) {
        this.startConferenceOnEnter = startConferenceOnEnter;
        return this;
    }

    public ReservationUpdater setEndConferenceOnExit(Boolean endConferenceOnExit) {
        this.endConferenceOnExit = endConferenceOnExit;
        return this;
    }

    public ReservationUpdater setWaitUrl(URI waitUrl) {
        this.waitUrl = waitUrl;
        return this;
    }

    public ReservationUpdater setWaitUrl(String waitUrl) {
        return this.setWaitUrl(Promoter.uriFromString(waitUrl));
    }

    public ReservationUpdater setWaitMethod(HttpMethod waitMethod) {
        this.waitMethod = waitMethod;
        return this;
    }

    public ReservationUpdater setEarlyMedia(Boolean earlyMedia) {
        this.earlyMedia = earlyMedia;
        return this;
    }

    public ReservationUpdater setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
        return this;
    }

    public ReservationUpdater setConferenceStatusCallback(URI conferenceStatusCallback) {
        this.conferenceStatusCallback = conferenceStatusCallback;
        return this;
    }

    public ReservationUpdater setConferenceStatusCallback(String conferenceStatusCallback) {
        return this.setConferenceStatusCallback(Promoter.uriFromString(conferenceStatusCallback));
    }

    public ReservationUpdater setConferenceStatusCallbackMethod(HttpMethod conferenceStatusCallbackMethod) {
        this.conferenceStatusCallbackMethod = conferenceStatusCallbackMethod;
        return this;
    }

    public ReservationUpdater setConferenceStatusCallbackEvent(List<Reservation.ConferenceEvent> conferenceStatusCallbackEvent) {
        this.conferenceStatusCallbackEvent = conferenceStatusCallbackEvent;
        return this;
    }

    public ReservationUpdater setConferenceStatusCallbackEvent(Reservation.ConferenceEvent conferenceStatusCallbackEvent) {
        return this.setConferenceStatusCallbackEvent(Promoter.listOfOne(conferenceStatusCallbackEvent));
    }

    public ReservationUpdater setConferenceRecord(String conferenceRecord) {
        this.conferenceRecord = conferenceRecord;
        return this;
    }

    public ReservationUpdater setConferenceTrim(String conferenceTrim) {
        this.conferenceTrim = conferenceTrim;
        return this;
    }

    public ReservationUpdater setRecordingChannels(String recordingChannels) {
        this.recordingChannels = recordingChannels;
        return this;
    }

    public ReservationUpdater setRecordingStatusCallback(URI recordingStatusCallback) {
        this.recordingStatusCallback = recordingStatusCallback;
        return this;
    }

    public ReservationUpdater setRecordingStatusCallback(String recordingStatusCallback) {
        return this.setRecordingStatusCallback(Promoter.uriFromString(recordingStatusCallback));
    }

    public ReservationUpdater setRecordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
        this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
        return this;
    }

    public ReservationUpdater setConferenceRecordingStatusCallback(URI conferenceRecordingStatusCallback) {
        this.conferenceRecordingStatusCallback = conferenceRecordingStatusCallback;
        return this;
    }

    public ReservationUpdater setConferenceRecordingStatusCallback(String conferenceRecordingStatusCallback) {
        return this.setConferenceRecordingStatusCallback(Promoter.uriFromString(conferenceRecordingStatusCallback));
    }

    public ReservationUpdater setConferenceRecordingStatusCallbackMethod(HttpMethod conferenceRecordingStatusCallbackMethod) {
        this.conferenceRecordingStatusCallbackMethod = conferenceRecordingStatusCallbackMethod;
        return this;
    }

    public ReservationUpdater setRegion(String region) {
        this.region = region;
        return this;
    }

    public ReservationUpdater setSipAuthUsername(String sipAuthUsername) {
        this.sipAuthUsername = sipAuthUsername;
        return this;
    }

    public ReservationUpdater setSipAuthPassword(String sipAuthPassword) {
        this.sipAuthPassword = sipAuthPassword;
        return this;
    }

    public ReservationUpdater setDequeueStatusCallbackEvent(List<String> dequeueStatusCallbackEvent) {
        this.dequeueStatusCallbackEvent = dequeueStatusCallbackEvent;
        return this;
    }

    public ReservationUpdater setDequeueStatusCallbackEvent(String dequeueStatusCallbackEvent) {
        return this.setDequeueStatusCallbackEvent(Promoter.listOfOne(dequeueStatusCallbackEvent));
    }

    public ReservationUpdater setPostWorkActivitySid(String postWorkActivitySid) {
        this.postWorkActivitySid = postWorkActivitySid;
        return this;
    }

    public ReservationUpdater setEndConferenceOnCustomerExit(Boolean endConferenceOnCustomerExit) {
        this.endConferenceOnCustomerExit = endConferenceOnCustomerExit;
        return this;
    }

    public ReservationUpdater setBeepOnCustomerEntrance(Boolean beepOnCustomerEntrance) {
        this.beepOnCustomerEntrance = beepOnCustomerEntrance;
        return this;
    }

    @Override
    public Reservation update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Workers/" + this.pathWorkerSid + "/Reservations/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Reservation update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Reservation.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.reservationStatus != null) {
            request.addPostParam("ReservationStatus", this.reservationStatus.toString());
        }
        if (this.workerActivitySid != null) {
            request.addPostParam("WorkerActivitySid", this.workerActivitySid);
        }
        if (this.instruction != null) {
            request.addPostParam("Instruction", this.instruction);
        }
        if (this.dequeuePostWorkActivitySid != null) {
            request.addPostParam("DequeuePostWorkActivitySid", this.dequeuePostWorkActivitySid);
        }
        if (this.dequeueFrom != null) {
            request.addPostParam("DequeueFrom", this.dequeueFrom);
        }
        if (this.dequeueRecord != null) {
            request.addPostParam("DequeueRecord", this.dequeueRecord);
        }
        if (this.dequeueTimeout != null) {
            request.addPostParam("DequeueTimeout", this.dequeueTimeout.toString());
        }
        if (this.dequeueTo != null) {
            request.addPostParam("DequeueTo", this.dequeueTo);
        }
        if (this.dequeueStatusCallbackUrl != null) {
            request.addPostParam("DequeueStatusCallbackUrl", this.dequeueStatusCallbackUrl.toString());
        }
        if (this.callFrom != null) {
            request.addPostParam("CallFrom", this.callFrom);
        }
        if (this.callRecord != null) {
            request.addPostParam("CallRecord", this.callRecord);
        }
        if (this.callTimeout != null) {
            request.addPostParam("CallTimeout", this.callTimeout.toString());
        }
        if (this.callTo != null) {
            request.addPostParam("CallTo", this.callTo);
        }
        if (this.callUrl != null) {
            request.addPostParam("CallUrl", this.callUrl.toString());
        }
        if (this.callStatusCallbackUrl != null) {
            request.addPostParam("CallStatusCallbackUrl", this.callStatusCallbackUrl.toString());
        }
        if (this.callAccept != null) {
            request.addPostParam("CallAccept", this.callAccept.toString());
        }
        if (this.redirectCallSid != null) {
            request.addPostParam("RedirectCallSid", this.redirectCallSid);
        }
        if (this.redirectAccept != null) {
            request.addPostParam("RedirectAccept", this.redirectAccept.toString());
        }
        if (this.redirectUrl != null) {
            request.addPostParam("RedirectUrl", this.redirectUrl.toString());
        }
        if (this.to != null) {
            request.addPostParam("To", this.to);
        }
        if (this.from != null) {
            request.addPostParam("From", this.from);
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.statusCallbackEvent != null) {
            for (Reservation.CallStatus callStatus : this.statusCallbackEvent) {
                request.addPostParam("StatusCallbackEvent", callStatus.toString());
            }
        }
        if (this.timeout != null) {
            request.addPostParam("Timeout", this.timeout.toString());
        }
        if (this.record != null) {
            request.addPostParam("Record", this.record.toString());
        }
        if (this.muted != null) {
            request.addPostParam("Muted", this.muted.toString());
        }
        if (this.beep != null) {
            request.addPostParam("Beep", this.beep);
        }
        if (this.startConferenceOnEnter != null) {
            request.addPostParam("StartConferenceOnEnter", this.startConferenceOnEnter.toString());
        }
        if (this.endConferenceOnExit != null) {
            request.addPostParam("EndConferenceOnExit", this.endConferenceOnExit.toString());
        }
        if (this.waitUrl != null) {
            request.addPostParam("WaitUrl", this.waitUrl.toString());
        }
        if (this.waitMethod != null) {
            request.addPostParam("WaitMethod", this.waitMethod.toString());
        }
        if (this.earlyMedia != null) {
            request.addPostParam("EarlyMedia", this.earlyMedia.toString());
        }
        if (this.maxParticipants != null) {
            request.addPostParam("MaxParticipants", this.maxParticipants.toString());
        }
        if (this.conferenceStatusCallback != null) {
            request.addPostParam("ConferenceStatusCallback", this.conferenceStatusCallback.toString());
        }
        if (this.conferenceStatusCallbackMethod != null) {
            request.addPostParam("ConferenceStatusCallbackMethod", this.conferenceStatusCallbackMethod.toString());
        }
        if (this.conferenceStatusCallbackEvent != null) {
            for (Reservation.ConferenceEvent conferenceEvent : this.conferenceStatusCallbackEvent) {
                request.addPostParam("ConferenceStatusCallbackEvent", conferenceEvent.toString());
            }
        }
        if (this.conferenceRecord != null) {
            request.addPostParam("ConferenceRecord", this.conferenceRecord);
        }
        if (this.conferenceTrim != null) {
            request.addPostParam("ConferenceTrim", this.conferenceTrim);
        }
        if (this.recordingChannels != null) {
            request.addPostParam("RecordingChannels", this.recordingChannels);
        }
        if (this.recordingStatusCallback != null) {
            request.addPostParam("RecordingStatusCallback", this.recordingStatusCallback.toString());
        }
        if (this.recordingStatusCallbackMethod != null) {
            request.addPostParam("RecordingStatusCallbackMethod", this.recordingStatusCallbackMethod.toString());
        }
        if (this.conferenceRecordingStatusCallback != null) {
            request.addPostParam("ConferenceRecordingStatusCallback", this.conferenceRecordingStatusCallback.toString());
        }
        if (this.conferenceRecordingStatusCallbackMethod != null) {
            request.addPostParam("ConferenceRecordingStatusCallbackMethod", this.conferenceRecordingStatusCallbackMethod.toString());
        }
        if (this.region != null) {
            request.addPostParam("Region", this.region);
        }
        if (this.sipAuthUsername != null) {
            request.addPostParam("SipAuthUsername", this.sipAuthUsername);
        }
        if (this.sipAuthPassword != null) {
            request.addPostParam("SipAuthPassword", this.sipAuthPassword);
        }
        if (this.dequeueStatusCallbackEvent != null) {
            for (String string : this.dequeueStatusCallbackEvent) {
                request.addPostParam("DequeueStatusCallbackEvent", string);
            }
        }
        if (this.postWorkActivitySid != null) {
            request.addPostParam("PostWorkActivitySid", this.postWorkActivitySid);
        }
        if (this.endConferenceOnCustomerExit != null) {
            request.addPostParam("EndConferenceOnCustomerExit", this.endConferenceOnCustomerExit.toString());
        }
        if (this.beepOnCustomerEntrance != null) {
            request.addPostParam("BeepOnCustomerEntrance", this.beepOnCustomerEntrance.toString());
        }
    }
}

