/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Worker;

public class WorkerUpdater
extends Updater<Worker> {
    private final String pathWorkspaceSid;
    private final String pathSid;
    private String activitySid;
    private String attributes;
    private String friendlyName;
    private Boolean rejectPendingReservations;

    public WorkerUpdater(String pathWorkspaceSid, String pathSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathSid = pathSid;
    }

    public WorkerUpdater setActivitySid(String activitySid) {
        this.activitySid = activitySid;
        return this;
    }

    public WorkerUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public WorkerUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public WorkerUpdater setRejectPendingReservations(Boolean rejectPendingReservations) {
        this.rejectPendingReservations = rejectPendingReservations;
        return this;
    }

    @Override
    public Worker update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Workers/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Worker update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Worker.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.activitySid != null) {
            request.addPostParam("ActivitySid", this.activitySid);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.rejectPendingReservations != null) {
            request.addPostParam("RejectPendingReservations", this.rejectPendingReservations.toString());
        }
    }
}

