/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.syncstream;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.syncstream.StreamMessage;
import java.util.Map;

public class StreamMessageCreator
extends Creator<StreamMessage> {
    private final String pathServiceSid;
    private final String pathStreamSid;
    private final Map<String, Object> data;

    public StreamMessageCreator(String pathServiceSid, String pathStreamSid, Map<String, Object> data) {
        this.pathServiceSid = pathServiceSid;
        this.pathStreamSid = pathStreamSid;
        this.data = data;
    }

    @Override
    public StreamMessage create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.SYNC.toString(), "/v1/Services/" + this.pathServiceSid + "/Streams/" + this.pathStreamSid + "/Messages");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("StreamMessage creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return StreamMessage.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.data != null) {
            request.addPostParam("Data", Converter.mapToJson(this.data));
        }
    }
}

