/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1.networkaccessprofile;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.networkaccessprofile.NetworkAccessProfileNetwork;

public class NetworkAccessProfileNetworkCreator
extends Creator<NetworkAccessProfileNetwork> {
    private final String pathNetworkAccessProfileSid;
    private final String network;

    public NetworkAccessProfileNetworkCreator(String pathNetworkAccessProfileSid, String network) {
        this.pathNetworkAccessProfileSid = pathNetworkAccessProfileSid;
        this.network = network;
    }

    @Override
    public NetworkAccessProfileNetwork create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), "/v1/NetworkAccessProfiles/" + this.pathNetworkAccessProfileSid + "/Networks");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("NetworkAccessProfileNetwork creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return NetworkAccessProfileNetwork.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.network != null) {
            request.addPostParam("Network", this.network);
        }
    }
}

