/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow.execution;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v2.flow.execution.ExecutionStep;

public class ExecutionStepFetcher
extends Fetcher<ExecutionStep> {
    private final String pathFlowSid;
    private final String pathExecutionSid;
    private final String pathSid;

    public ExecutionStepFetcher(String pathFlowSid, String pathExecutionSid, String pathSid) {
        this.pathFlowSid = pathFlowSid;
        this.pathExecutionSid = pathExecutionSid;
        this.pathSid = pathSid;
    }

    @Override
    public ExecutionStep fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), "/v2/Flows/" + this.pathFlowSid + "/Executions/" + this.pathExecutionSid + "/Steps/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ExecutionStep fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return ExecutionStep.fromJson(response.getStream(), client.getObjectMapper());
    }
}

