/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v2.flow.FlowTestUser;
import java.util.List;

public class FlowTestUserUpdater
extends Updater<FlowTestUser> {
    private final String pathSid;
    private final List<String> testUsers;

    public FlowTestUserUpdater(String pathSid, List<String> testUsers) {
        this.pathSid = pathSid;
        this.testUsers = testUsers;
    }

    @Override
    public FlowTestUser update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.STUDIO.toString(), "/v2/Flows/" + this.pathSid + "/TestUsers");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FlowTestUser update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return FlowTestUser.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.testUsers != null) {
            for (String prop : this.testUsers) {
                request.addPostParam("TestUsers", prop);
            }
        }
    }
}

