/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.Execution;
import org.joda.time.DateTime;

public class ExecutionReader
extends Reader<Execution> {
    private final String pathFlowSid;
    private DateTime dateCreatedFrom;
    private DateTime dateCreatedTo;

    public ExecutionReader(String pathFlowSid) {
        this.pathFlowSid = pathFlowSid;
    }

    public ExecutionReader setDateCreatedFrom(DateTime dateCreatedFrom) {
        this.dateCreatedFrom = dateCreatedFrom;
        return this;
    }

    public ExecutionReader setDateCreatedTo(DateTime dateCreatedTo) {
        this.dateCreatedTo = dateCreatedTo;
        return this;
    }

    @Override
    public ResourceSet<Execution> read(TwilioRestClient client) {
        return new ResourceSet<Execution>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Execution> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), "/v1/Flows/" + this.pathFlowSid + "/Executions");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Execution> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Execution> nextPage(Page<Execution> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Execution> previousPage(Page<Execution> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.STUDIO.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Execution> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Execution read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("executions", response.getContent(), Execution.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.dateCreatedFrom != null) {
            request.addQueryParam("DateCreatedFrom", this.dateCreatedFrom.toString());
        }
        if (this.dateCreatedTo != null) {
            request.addQueryParam("DateCreatedTo", this.dateCreatedTo.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

