/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.serverless.v1.service.BuildCreator;
import com.twilio.rest.serverless.v1.service.BuildDeleter;
import com.twilio.rest.serverless.v1.service.BuildFetcher;
import com.twilio.rest.serverless.v1.service.BuildReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Build
extends Resource {
    private static final long serialVersionUID = 35713800238774L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final Status status;
    private final List<Map<String, Object>> assetVersions;
    private final List<Map<String, Object>> functionVersions;
    private final List<Map<String, Object>> dependencies;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static BuildReader reader(String pathServiceSid) {
        return new BuildReader(pathServiceSid);
    }

    public static BuildFetcher fetcher(String pathServiceSid, String pathSid) {
        return new BuildFetcher(pathServiceSid, pathSid);
    }

    public static BuildDeleter deleter(String pathServiceSid, String pathSid) {
        return new BuildDeleter(pathServiceSid, pathSid);
    }

    public static BuildCreator creator(String pathServiceSid) {
        return new BuildCreator(pathServiceSid);
    }

    public static Build fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Build)objectMapper.readValue(json, Build.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Build fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Build)objectMapper.readValue(json, Build.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Build(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="status") Status status, @JsonProperty(value="asset_versions") List<Map<String, Object>> assetVersions, @JsonProperty(value="function_versions") List<Map<String, Object>> functionVersions, @JsonProperty(value="dependencies") List<Map<String, Object>> dependencies, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.status = status;
        this.assetVersions = assetVersions;
        this.functionVersions = functionVersions;
        this.dependencies = dependencies;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final List<Map<String, Object>> getAssetVersions() {
        return this.assetVersions;
    }

    public final List<Map<String, Object>> getFunctionVersions() {
        return this.functionVersions;
    }

    public final List<Map<String, Object>> getDependencies() {
        return this.dependencies;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Build other = (Build)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.assetVersions, other.assetVersions) && Objects.equals(this.functionVersions, other.functionVersions) && Objects.equals(this.dependencies, other.dependencies) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.status, this.assetVersions, this.functionVersions, this.dependencies, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("status", (Object)this.status).add("assetVersions", this.assetVersions).add("functionVersions", this.functionVersions).add("dependencies", this.dependencies).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }

    public static enum Status {
        BUILDING("building"),
        COMPLETED("completed"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

