/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.wireless;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.wireless.Sim;

public class SimReader
extends Reader<Sim> {
    private String status;
    private String iccid;
    private String ratePlan;
    private String eId;
    private String simRegistrationCode;

    public SimReader setStatus(String status) {
        this.status = status;
        return this;
    }

    public SimReader setIccid(String iccid) {
        this.iccid = iccid;
        return this;
    }

    public SimReader setRatePlan(String ratePlan) {
        this.ratePlan = ratePlan;
        return this;
    }

    public SimReader setEId(String eId) {
        this.eId = eId;
        return this;
    }

    public SimReader setSimRegistrationCode(String simRegistrationCode) {
        this.simRegistrationCode = simRegistrationCode;
        return this;
    }

    @Override
    public ResourceSet<Sim> read(TwilioRestClient client) {
        return new ResourceSet<Sim>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Sim> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/wireless/Sims");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Sim> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Sim> nextPage(Page<Sim> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Sim> previousPage(Page<Sim> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Sim> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Sim read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("sims", response.getContent(), Sim.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.status != null) {
            request.addQueryParam("Status", this.status);
        }
        if (this.iccid != null) {
            request.addQueryParam("Iccid", this.iccid);
        }
        if (this.ratePlan != null) {
            request.addQueryParam("RatePlan", this.ratePlan);
        }
        if (this.eId != null) {
            request.addQueryParam("EId", this.eId);
        }
        if (this.simRegistrationCode != null) {
            request.addQueryParam("SimRegistrationCode", this.simRegistrationCode);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

