/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.understand.assistant.AssistantInitiationActions;
import java.util.Map;

public class AssistantInitiationActionsUpdater
extends Updater<AssistantInitiationActions> {
    private final String pathAssistantSid;
    private Map<String, Object> initiationActions;

    public AssistantInitiationActionsUpdater(String pathAssistantSid) {
        this.pathAssistantSid = pathAssistantSid;
    }

    public AssistantInitiationActionsUpdater setInitiationActions(Map<String, Object> initiationActions) {
        this.initiationActions = initiationActions;
        return this;
    }

    @Override
    public AssistantInitiationActions update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/understand/Assistants/" + this.pathAssistantSid + "/InitiationActions");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AssistantInitiationActions update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return AssistantInitiationActions.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.initiationActions != null) {
            request.addPostParam("InitiationActions", Converter.mapToJson(this.initiationActions));
        }
    }
}

