/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms.business.insights;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.business.insights.ImpressionsRateFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ImpressionsRate
extends Resource {
    private static final long serialVersionUID = 11232973759334L;
    private final String accountSid;
    private final String businessSid;
    private final DateTime end;
    private final Intervals interval;
    private final Map<String, Object> reports;
    private final DateTime start;
    private final URI url;

    public static ImpressionsRateFetcher fetcher(String pathBusinessSid) {
        return new ImpressionsRateFetcher(pathBusinessSid);
    }

    public static ImpressionsRate fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ImpressionsRate)objectMapper.readValue(json, ImpressionsRate.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ImpressionsRate fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ImpressionsRate)objectMapper.readValue(json, ImpressionsRate.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ImpressionsRate(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="business_sid") String businessSid, @JsonProperty(value="end") String end, @JsonProperty(value="interval") Intervals interval, @JsonProperty(value="reports") Map<String, Object> reports, @JsonProperty(value="start") String start, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.businessSid = businessSid;
        this.end = DateConverter.iso8601DateTimeFromString(end);
        this.interval = interval;
        this.reports = reports;
        this.start = DateConverter.iso8601DateTimeFromString(start);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getBusinessSid() {
        return this.businessSid;
    }

    public final DateTime getEnd() {
        return this.end;
    }

    public final Intervals getInterval() {
        return this.interval;
    }

    public final Map<String, Object> getReports() {
        return this.reports;
    }

    public final DateTime getStart() {
        return this.start;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImpressionsRate other = (ImpressionsRate)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.businessSid, other.businessSid) && Objects.equals(this.end, other.end) && Objects.equals((Object)this.interval, (Object)other.interval) && Objects.equals(this.reports, other.reports) && Objects.equals(this.start, other.start) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.businessSid, this.end, this.interval, this.reports, this.start, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("businessSid", (Object)this.businessSid).add("end", (Object)this.end).add("interval", (Object)this.interval).add("reports", this.reports).add("start", (Object)this.start).add("url", (Object)this.url).toString();
    }

    public static enum Intervals {
        MINUTE("minute"),
        HOUR("hour"),
        DAY("day"),
        WEEK("week"),
        MONTH("month");

        private final String value;

        private Intervals(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Intervals forValue(String value) {
            return (Intervals)Promoter.enumFromString((String)value, (Enum[])Intervals.values());
        }
    }
}

