/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.marketplace.installedaddon;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.marketplace.installedaddon.InstalledAddOnExtension;

public class InstalledAddOnExtensionUpdater
extends Updater<InstalledAddOnExtension> {
    private final String pathInstalledAddOnSid;
    private final String pathSid;
    private final Boolean enabled;

    public InstalledAddOnExtensionUpdater(String pathInstalledAddOnSid, String pathSid, Boolean enabled) {
        this.pathInstalledAddOnSid = pathInstalledAddOnSid;
        this.pathSid = pathSid;
        this.enabled = enabled;
    }

    @Override
    public InstalledAddOnExtension update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/marketplace/InstalledAddOns/" + this.pathInstalledAddOnSid + "/Extensions/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InstalledAddOnExtension update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return InstalledAddOnExtension.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.enabled != null) {
            request.addPostParam("Enabled", this.enabled.toString());
        }
    }
}

