/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service.channel;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v2.service.channel.Member;
import org.joda.time.DateTime;

public class MemberUpdater
extends Updater<Member> {
    private final String pathServiceSid;
    private final String pathChannelSid;
    private final String pathSid;
    private String roleSid;
    private Integer lastConsumedMessageIndex;
    private DateTime lastConsumptionTimestamp;
    private DateTime dateCreated;
    private DateTime dateUpdated;
    private String attributes;
    private Member.WebhookEnabledType xTwilioWebhookEnabled;

    public MemberUpdater(String pathServiceSid, String pathChannelSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathChannelSid = pathChannelSid;
        this.pathSid = pathSid;
    }

    public MemberUpdater setRoleSid(String roleSid) {
        this.roleSid = roleSid;
        return this;
    }

    public MemberUpdater setLastConsumedMessageIndex(Integer lastConsumedMessageIndex) {
        this.lastConsumedMessageIndex = lastConsumedMessageIndex;
        return this;
    }

    public MemberUpdater setLastConsumptionTimestamp(DateTime lastConsumptionTimestamp) {
        this.lastConsumptionTimestamp = lastConsumptionTimestamp;
        return this;
    }

    public MemberUpdater setDateCreated(DateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public MemberUpdater setDateUpdated(DateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public MemberUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public MemberUpdater setXTwilioWebhookEnabled(Member.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    @Override
    public Member update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.IPMESSAGING.toString(), "/v2/Services/" + this.pathServiceSid + "/Channels/" + this.pathChannelSid + "/Members/" + this.pathSid + "");
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Member.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }

    private void addPostParams(Request request) {
        if (this.roleSid != null) {
            request.addPostParam("RoleSid", this.roleSid);
        }
        if (this.lastConsumedMessageIndex != null) {
            request.addPostParam("LastConsumedMessageIndex", this.lastConsumedMessageIndex.toString());
        }
        if (this.lastConsumptionTimestamp != null) {
            request.addPostParam("LastConsumptionTimestamp", this.lastConsumptionTimestamp.toString());
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toString());
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
    }
}

