/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.Role;

public class RoleReader
extends Reader<Role> {
    @Override
    public ResourceSet<Role> read(TwilioRestClient client) {
        return new ResourceSet<Role>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Role> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), "/v1/Roles");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Role> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Role> nextPage(Page<Role> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Role> previousPage(Page<Role> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Role> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Role read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("roles", response.getContent(), Role.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

