/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant.task;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.assistant.task.TaskActions;

public class TaskActionsFetcher
extends Fetcher<TaskActions> {
    private final String pathAssistantSid;
    private final String pathTaskSid;

    public TaskActionsFetcher(String pathAssistantSid, String pathTaskSid) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathTaskSid = pathTaskSid;
    }

    @Override
    public TaskActions fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.AUTOPILOT.toString(), "/v1/Assistants/" + this.pathAssistantSid + "/Tasks/" + this.pathTaskSid + "/Actions");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskActions fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return TaskActions.fromJson(response.getStream(), client.getObjectMapper());
    }
}

