/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.assistant.Task;
import java.net.URI;
import java.util.Map;

public class TaskUpdater
extends Updater<Task> {
    private final String pathAssistantSid;
    private final String pathSid;
    private String friendlyName;
    private String uniqueName;
    private Map<String, Object> actions;
    private URI actionsUrl;

    public TaskUpdater(String pathAssistantSid, String pathSid) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathSid = pathSid;
    }

    public TaskUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public TaskUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public TaskUpdater setActions(Map<String, Object> actions) {
        this.actions = actions;
        return this;
    }

    public TaskUpdater setActionsUrl(URI actionsUrl) {
        this.actionsUrl = actionsUrl;
        return this;
    }

    public TaskUpdater setActionsUrl(String actionsUrl) {
        return this.setActionsUrl(Promoter.uriFromString(actionsUrl));
    }

    @Override
    public Task update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTOPILOT.toString(), "/v1/Assistants/" + this.pathAssistantSid + "/Tasks/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Task update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Task.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.actions != null) {
            request.addPostParam("Actions", Converter.mapToJson(this.actions));
        }
        if (this.actionsUrl != null) {
            request.addPostParam("ActionsUrl", this.actionsUrl.toString());
        }
    }
}

