/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.address;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.api.v2010.account.address.DependentPhoneNumberReader;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DependentPhoneNumber
extends Resource {
    private static final long serialVersionUID = 25853317680371L;
    private final String sid;
    private final String accountSid;
    private final PhoneNumber friendlyName;
    private final PhoneNumber phoneNumber;
    private final URI voiceUrl;
    private final HttpMethod voiceMethod;
    private final HttpMethod voiceFallbackMethod;
    private final URI voiceFallbackUrl;
    private final Boolean voiceCallerIdLookup;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final HttpMethod smsFallbackMethod;
    private final URI smsFallbackUrl;
    private final HttpMethod smsMethod;
    private final URI smsUrl;
    private final AddressRequirement addressRequirements;
    private final Map<String, Object> capabilities;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final String apiVersion;
    private final String smsApplicationSid;
    private final String voiceApplicationSid;
    private final String trunkSid;
    private final EmergencyStatus emergencyStatus;
    private final String emergencyAddressSid;
    private final String uri;

    public static DependentPhoneNumberReader reader(String pathAccountSid, String pathAddressSid) {
        return new DependentPhoneNumberReader(pathAccountSid, pathAddressSid);
    }

    public static DependentPhoneNumberReader reader(String pathAddressSid) {
        return new DependentPhoneNumberReader(pathAddressSid);
    }

    public static DependentPhoneNumber fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (DependentPhoneNumber)objectMapper.readValue(json, DependentPhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static DependentPhoneNumber fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (DependentPhoneNumber)objectMapper.readValue(json, DependentPhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private DependentPhoneNumber(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") PhoneNumber friendlyName, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="voice_url") URI voiceUrl, @JsonProperty(value="voice_method") HttpMethod voiceMethod, @JsonProperty(value="voice_fallback_method") HttpMethod voiceFallbackMethod, @JsonProperty(value="voice_fallback_url") URI voiceFallbackUrl, @JsonProperty(value="voice_caller_id_lookup") Boolean voiceCallerIdLookup, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="sms_fallback_method") HttpMethod smsFallbackMethod, @JsonProperty(value="sms_fallback_url") URI smsFallbackUrl, @JsonProperty(value="sms_method") HttpMethod smsMethod, @JsonProperty(value="sms_url") URI smsUrl, @JsonProperty(value="address_requirements") AddressRequirement addressRequirements, @JsonProperty(value="capabilities") Map<String, Object> capabilities, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="status_callback_method") HttpMethod statusCallbackMethod, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="sms_application_sid") String smsApplicationSid, @JsonProperty(value="voice_application_sid") String voiceApplicationSid, @JsonProperty(value="trunk_sid") String trunkSid, @JsonProperty(value="emergency_status") EmergencyStatus emergencyStatus, @JsonProperty(value="emergency_address_sid") String emergencyAddressSid, @JsonProperty(value="uri") String uri) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.phoneNumber = phoneNumber;
        this.voiceUrl = voiceUrl;
        this.voiceMethod = voiceMethod;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceCallerIdLookup = voiceCallerIdLookup;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.smsFallbackMethod = smsFallbackMethod;
        this.smsFallbackUrl = smsFallbackUrl;
        this.smsMethod = smsMethod;
        this.smsUrl = smsUrl;
        this.addressRequirements = addressRequirements;
        this.capabilities = capabilities;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.apiVersion = apiVersion;
        this.smsApplicationSid = smsApplicationSid;
        this.voiceApplicationSid = voiceApplicationSid;
        this.trunkSid = trunkSid;
        this.emergencyStatus = emergencyStatus;
        this.emergencyAddressSid = emergencyAddressSid;
        this.uri = uri;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final PhoneNumber getFriendlyName() {
        return this.friendlyName;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public final HttpMethod getVoiceMethod() {
        return this.voiceMethod;
    }

    public final HttpMethod getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    public final URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    public final Boolean getVoiceCallerIdLookup() {
        return this.voiceCallerIdLookup;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final HttpMethod getSmsFallbackMethod() {
        return this.smsFallbackMethod;
    }

    public final URI getSmsFallbackUrl() {
        return this.smsFallbackUrl;
    }

    public final HttpMethod getSmsMethod() {
        return this.smsMethod;
    }

    public final URI getSmsUrl() {
        return this.smsUrl;
    }

    public final AddressRequirement getAddressRequirements() {
        return this.addressRequirements;
    }

    public final Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getSmsApplicationSid() {
        return this.smsApplicationSid;
    }

    public final String getVoiceApplicationSid() {
        return this.voiceApplicationSid;
    }

    public final String getTrunkSid() {
        return this.trunkSid;
    }

    public final EmergencyStatus getEmergencyStatus() {
        return this.emergencyStatus;
    }

    public final String getEmergencyAddressSid() {
        return this.emergencyAddressSid;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependentPhoneNumber other = (DependentPhoneNumber)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.voiceUrl, other.voiceUrl) && Objects.equals((Object)this.voiceMethod, (Object)other.voiceMethod) && Objects.equals((Object)this.voiceFallbackMethod, (Object)other.voiceFallbackMethod) && Objects.equals(this.voiceFallbackUrl, other.voiceFallbackUrl) && Objects.equals(this.voiceCallerIdLookup, other.voiceCallerIdLookup) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals((Object)this.smsFallbackMethod, (Object)other.smsFallbackMethod) && Objects.equals(this.smsFallbackUrl, other.smsFallbackUrl) && Objects.equals((Object)this.smsMethod, (Object)other.smsMethod) && Objects.equals(this.smsUrl, other.smsUrl) && Objects.equals((Object)this.addressRequirements, (Object)other.addressRequirements) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals((Object)this.statusCallbackMethod, (Object)other.statusCallbackMethod) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.smsApplicationSid, other.smsApplicationSid) && Objects.equals(this.voiceApplicationSid, other.voiceApplicationSid) && Objects.equals(this.trunkSid, other.trunkSid) && Objects.equals((Object)this.emergencyStatus, (Object)other.emergencyStatus) && Objects.equals(this.emergencyAddressSid, other.emergencyAddressSid) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.friendlyName, this.phoneNumber, this.voiceUrl, this.voiceMethod, this.voiceFallbackMethod, this.voiceFallbackUrl, this.voiceCallerIdLookup, this.dateCreated, this.dateUpdated, this.smsFallbackMethod, this.smsFallbackUrl, this.smsMethod, this.smsUrl, this.addressRequirements, this.capabilities, this.statusCallback, this.statusCallbackMethod, this.apiVersion, this.smsApplicationSid, this.voiceApplicationSid, this.trunkSid, this.emergencyStatus, this.emergencyAddressSid, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("phoneNumber", (Object)this.phoneNumber).add("voiceUrl", (Object)this.voiceUrl).add("voiceMethod", (Object)this.voiceMethod).add("voiceFallbackMethod", (Object)this.voiceFallbackMethod).add("voiceFallbackUrl", (Object)this.voiceFallbackUrl).add("voiceCallerIdLookup", (Object)this.voiceCallerIdLookup).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("smsFallbackMethod", (Object)this.smsFallbackMethod).add("smsFallbackUrl", (Object)this.smsFallbackUrl).add("smsMethod", (Object)this.smsMethod).add("smsUrl", (Object)this.smsUrl).add("addressRequirements", (Object)this.addressRequirements).add("capabilities", this.capabilities).add("statusCallback", (Object)this.statusCallback).add("statusCallbackMethod", (Object)this.statusCallbackMethod).add("apiVersion", (Object)this.apiVersion).add("smsApplicationSid", (Object)this.smsApplicationSid).add("voiceApplicationSid", (Object)this.voiceApplicationSid).add("trunkSid", (Object)this.trunkSid).add("emergencyStatus", (Object)this.emergencyStatus).add("emergencyAddressSid", (Object)this.emergencyAddressSid).add("uri", (Object)this.uri).toString();
    }

    public static enum EmergencyStatus {
        ACTIVE("Active"),
        INACTIVE("Inactive");

        private final String value;

        private EmergencyStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static EmergencyStatus forValue(String value) {
            return (EmergencyStatus)Promoter.enumFromString((String)value, (Enum[])EmergencyStatus.values());
        }
    }

    public static enum AddressRequirement {
        NONE("none"),
        ANY("any"),
        LOCAL("local"),
        FOREIGN("foreign");

        private final String value;

        private AddressRequirement(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static AddressRequirement forValue(String value) {
            return (AddressRequirement)Promoter.enumFromString((String)value, (Enum[])AddressRequirement.values());
        }
    }
}

