/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.connectionpolicy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.voice.v1.connectionpolicy.ConnectionPolicyTargetCreator;
import com.twilio.rest.voice.v1.connectionpolicy.ConnectionPolicyTargetDeleter;
import com.twilio.rest.voice.v1.connectionpolicy.ConnectionPolicyTargetFetcher;
import com.twilio.rest.voice.v1.connectionpolicy.ConnectionPolicyTargetReader;
import com.twilio.rest.voice.v1.connectionpolicy.ConnectionPolicyTargetUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectionPolicyTarget
extends Resource {
    private static final long serialVersionUID = 215374980582138L;
    private final String accountSid;
    private final String connectionPolicySid;
    private final String sid;
    private final String friendlyName;
    private final URI target;
    private final Integer priority;
    private final Integer weight;
    private final Boolean enabled;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static ConnectionPolicyTargetCreator creator(String pathConnectionPolicySid, URI target) {
        return new ConnectionPolicyTargetCreator(pathConnectionPolicySid, target);
    }

    public static ConnectionPolicyTargetFetcher fetcher(String pathConnectionPolicySid, String pathSid) {
        return new ConnectionPolicyTargetFetcher(pathConnectionPolicySid, pathSid);
    }

    public static ConnectionPolicyTargetReader reader(String pathConnectionPolicySid) {
        return new ConnectionPolicyTargetReader(pathConnectionPolicySid);
    }

    public static ConnectionPolicyTargetUpdater updater(String pathConnectionPolicySid, String pathSid) {
        return new ConnectionPolicyTargetUpdater(pathConnectionPolicySid, pathSid);
    }

    public static ConnectionPolicyTargetDeleter deleter(String pathConnectionPolicySid, String pathSid) {
        return new ConnectionPolicyTargetDeleter(pathConnectionPolicySid, pathSid);
    }

    public static ConnectionPolicyTarget fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ConnectionPolicyTarget)objectMapper.readValue(json, ConnectionPolicyTarget.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ConnectionPolicyTarget fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ConnectionPolicyTarget)objectMapper.readValue(json, ConnectionPolicyTarget.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ConnectionPolicyTarget(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="connection_policy_sid") String connectionPolicySid, @JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="target") URI target, @JsonProperty(value="priority") Integer priority, @JsonProperty(value="weight") Integer weight, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.connectionPolicySid = connectionPolicySid;
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.target = target;
        this.priority = priority;
        this.weight = weight;
        this.enabled = enabled;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getConnectionPolicySid() {
        return this.connectionPolicySid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final URI getTarget() {
        return this.target;
    }

    public final Integer getPriority() {
        return this.priority;
    }

    public final Integer getWeight() {
        return this.weight;
    }

    public final Boolean getEnabled() {
        return this.enabled;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPolicyTarget other = (ConnectionPolicyTarget)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.connectionPolicySid, other.connectionPolicySid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.target, other.target) && Objects.equals(this.priority, other.priority) && Objects.equals(this.weight, other.weight) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.connectionPolicySid, this.sid, this.friendlyName, this.target, this.priority, this.weight, this.enabled, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("connectionPolicySid", (Object)this.connectionPolicySid).add("sid", (Object)this.sid).add("friendlyName", (Object)this.friendlyName).add("target", (Object)this.target).add("priority", (Object)this.priority).add("weight", (Object)this.weight).add("enabled", (Object)this.enabled).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }
}

