/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.entity;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.entity.Challenge;

public class ChallengeReader
extends Reader<Challenge> {
    private final String pathServiceSid;
    private final String pathIdentity;
    private String factorSid;
    private Challenge.ChallengeStatuses status;
    private String twilioSandboxMode;

    public ChallengeReader(String pathServiceSid, String pathIdentity) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
    }

    public ChallengeReader setFactorSid(String factorSid) {
        this.factorSid = factorSid;
        return this;
    }

    public ChallengeReader setStatus(Challenge.ChallengeStatuses status) {
        this.status = status;
        return this;
    }

    public ChallengeReader setTwilioSandboxMode(String twilioSandboxMode) {
        this.twilioSandboxMode = twilioSandboxMode;
        return this;
    }

    @Override
    public ResourceSet<Challenge> read(TwilioRestClient client) {
        return new ResourceSet<Challenge>(this, client, this.firstPage(client));
    }

    private void addHeaderParams(Request request) {
        if (this.twilioSandboxMode != null) {
            request.addHeaderParam("Twilio-Sandbox-Mode", this.twilioSandboxMode);
        }
    }

    @Override
    public Page<Challenge> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), "/v2/Services/" + this.pathServiceSid + "/Entities/" + this.pathIdentity + "/Challenges");
        this.addQueryParams(request);
        this.addHeaderParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Challenge> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Challenge> nextPage(Page<Challenge> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Challenge> previousPage(Page<Challenge> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VERIFY.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Challenge> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Challenge read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("challenges", response.getContent(), Challenge.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.factorSid != null) {
            request.addQueryParam("FactorSid", this.factorSid);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

