/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.Entity;

public class EntityCreator
extends Creator<Entity> {
    private final String pathServiceSid;
    private final String identity;
    private String twilioSandboxMode;

    public EntityCreator(String pathServiceSid, String identity) {
        this.pathServiceSid = pathServiceSid;
        this.identity = identity;
    }

    public EntityCreator setTwilioSandboxMode(String twilioSandboxMode) {
        this.twilioSandboxMode = twilioSandboxMode;
        return this;
    }

    @Override
    public Entity create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), "/v2/Services/" + this.pathServiceSid + "/Entities");
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Entity creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Entity.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.twilioSandboxMode != null) {
            request.addHeaderParam("Twilio-Sandbox-Mode", this.twilioSandboxMode);
        }
    }

    private void addPostParams(Request request) {
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
    }
}

