/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.WorkspaceRealTimeStatisticsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkspaceRealTimeStatistics
extends Resource {
    private static final long serialVersionUID = 18728955594793L;
    private final String accountSid;
    private final List<Map<String, Object>> activityStatistics;
    private final Integer longestTaskWaitingAge;
    private final String longestTaskWaitingSid;
    private final Map<String, Object> tasksByPriority;
    private final Map<String, Object> tasksByStatus;
    private final Integer totalTasks;
    private final Integer totalWorkers;
    private final String workspaceSid;
    private final URI url;

    public static WorkspaceRealTimeStatisticsFetcher fetcher(String pathWorkspaceSid) {
        return new WorkspaceRealTimeStatisticsFetcher(pathWorkspaceSid);
    }

    public static WorkspaceRealTimeStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (WorkspaceRealTimeStatistics)objectMapper.readValue(json, WorkspaceRealTimeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkspaceRealTimeStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (WorkspaceRealTimeStatistics)objectMapper.readValue(json, WorkspaceRealTimeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkspaceRealTimeStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="activity_statistics") List<Map<String, Object>> activityStatistics, @JsonProperty(value="longest_task_waiting_age") Integer longestTaskWaitingAge, @JsonProperty(value="longest_task_waiting_sid") String longestTaskWaitingSid, @JsonProperty(value="tasks_by_priority") Map<String, Object> tasksByPriority, @JsonProperty(value="tasks_by_status") Map<String, Object> tasksByStatus, @JsonProperty(value="total_tasks") Integer totalTasks, @JsonProperty(value="total_workers") Integer totalWorkers, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.activityStatistics = activityStatistics;
        this.longestTaskWaitingAge = longestTaskWaitingAge;
        this.longestTaskWaitingSid = longestTaskWaitingSid;
        this.tasksByPriority = tasksByPriority;
        this.tasksByStatus = tasksByStatus;
        this.totalTasks = totalTasks;
        this.totalWorkers = totalWorkers;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final List<Map<String, Object>> getActivityStatistics() {
        return this.activityStatistics;
    }

    public final Integer getLongestTaskWaitingAge() {
        return this.longestTaskWaitingAge;
    }

    public final String getLongestTaskWaitingSid() {
        return this.longestTaskWaitingSid;
    }

    public final Map<String, Object> getTasksByPriority() {
        return this.tasksByPriority;
    }

    public final Map<String, Object> getTasksByStatus() {
        return this.tasksByStatus;
    }

    public final Integer getTotalTasks() {
        return this.totalTasks;
    }

    public final Integer getTotalWorkers() {
        return this.totalWorkers;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkspaceRealTimeStatistics other = (WorkspaceRealTimeStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.activityStatistics, other.activityStatistics) && Objects.equals(this.longestTaskWaitingAge, other.longestTaskWaitingAge) && Objects.equals(this.longestTaskWaitingSid, other.longestTaskWaitingSid) && Objects.equals(this.tasksByPriority, other.tasksByPriority) && Objects.equals(this.tasksByStatus, other.tasksByStatus) && Objects.equals(this.totalTasks, other.totalTasks) && Objects.equals(this.totalWorkers, other.totalWorkers) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.activityStatistics, this.longestTaskWaitingAge, this.longestTaskWaitingSid, this.tasksByPriority, this.tasksByStatus, this.totalTasks, this.totalWorkers, this.workspaceSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("activityStatistics", this.activityStatistics).add("longestTaskWaitingAge", (Object)this.longestTaskWaitingAge).add("longestTaskWaitingSid", (Object)this.longestTaskWaitingSid).add("tasksByPriority", this.tasksByPriority).add("tasksByStatus", this.tasksByStatus).add("totalTasks", (Object)this.totalTasks).add("totalWorkers", (Object)this.totalWorkers).add("workspaceSid", (Object)this.workspaceSid).add("url", (Object)this.url).toString();
    }
}

