/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.SyncMap;

public class SyncMapUpdater
extends Updater<SyncMap> {
    private final String pathServiceSid;
    private final String pathSid;
    private Integer ttl;
    private Integer collectionTtl;

    public SyncMapUpdater(String pathServiceSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    public SyncMapUpdater setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public SyncMapUpdater setCollectionTtl(Integer collectionTtl) {
        this.collectionTtl = collectionTtl;
        return this;
    }

    @Override
    public SyncMap update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.SYNC.toString(), "/v1/Services/" + this.pathServiceSid + "/Maps/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncMap update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return SyncMap.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
        if (this.collectionTtl != null) {
            request.addPostParam("CollectionTtl", this.collectionTtl.toString());
        }
    }
}

