/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1.networkaccessprofile;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.networkaccessprofile.NetworkAccessProfileNetwork;

public class NetworkAccessProfileNetworkFetcher
extends Fetcher<NetworkAccessProfileNetwork> {
    private final String pathNetworkAccessProfileSid;
    private final String pathSid;

    public NetworkAccessProfileNetworkFetcher(String pathNetworkAccessProfileSid, String pathSid) {
        this.pathNetworkAccessProfileSid = pathNetworkAccessProfileSid;
        this.pathSid = pathSid;
    }

    @Override
    public NetworkAccessProfileNetwork fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), "/v1/NetworkAccessProfiles/" + this.pathNetworkAccessProfileSid + "/Networks/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("NetworkAccessProfileNetwork fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return NetworkAccessProfileNetwork.fromJson(response.getStream(), client.getObjectMapper());
    }
}

