/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.supersim.v1.FleetCreator;
import com.twilio.rest.supersim.v1.FleetFetcher;
import com.twilio.rest.supersim.v1.FleetReader;
import com.twilio.rest.supersim.v1.FleetUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Fleet
extends Resource {
    private static final long serialVersionUID = 262022242180029L;
    private final String accountSid;
    private final String sid;
    private final String uniqueName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Boolean dataEnabled;
    private final Integer dataLimit;
    private final DataMetering dataMetering;
    private final Boolean commandsEnabled;
    private final URI commandsUrl;
    private final HttpMethod commandsMethod;
    private final String networkAccessProfileSid;

    public static FleetCreator creator(String networkAccessProfile) {
        return new FleetCreator(networkAccessProfile);
    }

    public static FleetFetcher fetcher(String pathSid) {
        return new FleetFetcher(pathSid);
    }

    public static FleetReader reader() {
        return new FleetReader();
    }

    public static FleetUpdater updater(String pathSid) {
        return new FleetUpdater(pathSid);
    }

    public static Fleet fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Fleet)objectMapper.readValue(json, Fleet.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Fleet fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Fleet)objectMapper.readValue(json, Fleet.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Fleet(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="data_enabled") Boolean dataEnabled, @JsonProperty(value="data_limit") Integer dataLimit, @JsonProperty(value="data_metering") DataMetering dataMetering, @JsonProperty(value="commands_enabled") Boolean commandsEnabled, @JsonProperty(value="commands_url") URI commandsUrl, @JsonProperty(value="commands_method") HttpMethod commandsMethod, @JsonProperty(value="network_access_profile_sid") String networkAccessProfileSid) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.dataEnabled = dataEnabled;
        this.dataLimit = dataLimit;
        this.dataMetering = dataMetering;
        this.commandsEnabled = commandsEnabled;
        this.commandsUrl = commandsUrl;
        this.commandsMethod = commandsMethod;
        this.networkAccessProfileSid = networkAccessProfileSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Boolean getDataEnabled() {
        return this.dataEnabled;
    }

    public final Integer getDataLimit() {
        return this.dataLimit;
    }

    public final DataMetering getDataMetering() {
        return this.dataMetering;
    }

    public final Boolean getCommandsEnabled() {
        return this.commandsEnabled;
    }

    public final URI getCommandsUrl() {
        return this.commandsUrl;
    }

    public final HttpMethod getCommandsMethod() {
        return this.commandsMethod;
    }

    public final String getNetworkAccessProfileSid() {
        return this.networkAccessProfileSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fleet other = (Fleet)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.dataEnabled, other.dataEnabled) && Objects.equals(this.dataLimit, other.dataLimit) && Objects.equals((Object)this.dataMetering, (Object)other.dataMetering) && Objects.equals(this.commandsEnabled, other.commandsEnabled) && Objects.equals(this.commandsUrl, other.commandsUrl) && Objects.equals((Object)this.commandsMethod, (Object)other.commandsMethod) && Objects.equals(this.networkAccessProfileSid, other.networkAccessProfileSid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.sid, this.uniqueName, this.dateCreated, this.dateUpdated, this.url, this.dataEnabled, this.dataLimit, this.dataMetering, this.commandsEnabled, this.commandsUrl, this.commandsMethod, this.networkAccessProfileSid});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("sid", (Object)this.sid).add("uniqueName", (Object)this.uniqueName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).add("dataEnabled", (Object)this.dataEnabled).add("dataLimit", (Object)this.dataLimit).add("dataMetering", (Object)this.dataMetering).add("commandsEnabled", (Object)this.commandsEnabled).add("commandsUrl", (Object)this.commandsUrl).add("commandsMethod", (Object)this.commandsMethod).add("networkAccessProfileSid", (Object)this.networkAccessProfileSid).toString();
    }

    public static enum DataMetering {
        PAYG("payg");

        private final String value;

        private DataMetering(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static DataMetering forValue(String value) {
            return (DataMetering)Promoter.enumFromString((String)value, (Enum[])DataMetering.values());
        }
    }
}

