/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow.engagement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.studio.v1.flow.engagement.StepFetcher;
import com.twilio.rest.studio.v1.flow.engagement.StepReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Step
extends Resource {
    private static final long serialVersionUID = 221317830784095L;
    private final String sid;
    private final String accountSid;
    private final String flowSid;
    private final String engagementSid;
    private final String name;
    private final Map<String, Object> context;
    private final String transitionedFrom;
    private final String transitionedTo;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static StepReader reader(String pathFlowSid, String pathEngagementSid) {
        return new StepReader(pathFlowSid, pathEngagementSid);
    }

    public static StepFetcher fetcher(String pathFlowSid, String pathEngagementSid, String pathSid) {
        return new StepFetcher(pathFlowSid, pathEngagementSid, pathSid);
    }

    public static Step fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Step)objectMapper.readValue(json, Step.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Step fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Step)objectMapper.readValue(json, Step.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Step(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="flow_sid") String flowSid, @JsonProperty(value="engagement_sid") String engagementSid, @JsonProperty(value="name") String name, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="transitioned_from") String transitionedFrom, @JsonProperty(value="transitioned_to") String transitionedTo, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.flowSid = flowSid;
        this.engagementSid = engagementSid;
        this.name = name;
        this.context = context;
        this.transitionedFrom = transitionedFrom;
        this.transitionedTo = transitionedTo;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFlowSid() {
        return this.flowSid;
    }

    public final String getEngagementSid() {
        return this.engagementSid;
    }

    public final String getName() {
        return this.name;
    }

    public final Map<String, Object> getContext() {
        return this.context;
    }

    public final String getTransitionedFrom() {
        return this.transitionedFrom;
    }

    public final String getTransitionedTo() {
        return this.transitionedTo;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Step other = (Step)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.flowSid, other.flowSid) && Objects.equals(this.engagementSid, other.engagementSid) && Objects.equals(this.name, other.name) && Objects.equals(this.context, other.context) && Objects.equals(this.transitionedFrom, other.transitionedFrom) && Objects.equals(this.transitionedTo, other.transitionedTo) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.flowSid, this.engagementSid, this.name, this.context, this.transitionedFrom, this.transitionedTo, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("flowSid", (Object)this.flowSid).add("engagementSid", (Object)this.engagementSid).add("name", (Object)this.name).add("context", this.context).add("transitionedFrom", (Object)this.transitionedFrom).add("transitionedTo", (Object)this.transitionedTo).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).add("links", this.links).toString();
    }
}

