/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.pricing.v1.messaging;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.pricing.v1.messaging.Country;

public class CountryFetcher
extends Fetcher<Country> {
    private final String pathIsoCountry;

    public CountryFetcher(String pathIsoCountry) {
        this.pathIsoCountry = pathIsoCountry;
    }

    @Override
    public Country fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PRICING.toString(), "/v1/Messaging/Countries/" + this.pathIsoCountry + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Country fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Country.fromJson(response.getStream(), client.getObjectMapper());
    }
}

