/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.syncmap;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.syncmap.SyncMapItem;
import java.util.Map;

public class SyncMapItemCreator
extends Creator<SyncMapItem> {
    private final String pathServiceSid;
    private final String pathMapSid;
    private final String key;
    private final Map<String, Object> data;

    public SyncMapItemCreator(String pathServiceSid, String pathMapSid, String key, Map<String, Object> data) {
        this.pathServiceSid = pathServiceSid;
        this.pathMapSid = pathMapSid;
        this.key = key;
        this.data = data;
    }

    @Override
    public SyncMapItem create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/Sync/Services/" + this.pathServiceSid + "/Maps/" + this.pathMapSid + "/Items");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncMapItem creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return SyncMapItem.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.key != null) {
            request.addPostParam("Key", this.key);
        }
        if (this.data != null) {
            request.addPostParam("Data", Converter.mapToJson(this.data));
        }
    }
}

