/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.synclist;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.synclist.SyncListPermission;

public class SyncListPermissionReader
extends Reader<SyncListPermission> {
    private final String pathServiceSid;
    private final String pathListSid;

    public SyncListPermissionReader(String pathServiceSid, String pathListSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathListSid = pathListSid;
    }

    @Override
    public ResourceSet<SyncListPermission> read(TwilioRestClient client) {
        return new ResourceSet<SyncListPermission>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SyncListPermission> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/Sync/Services/" + this.pathServiceSid + "/Lists/" + this.pathListSid + "/Permissions");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncListPermission> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncListPermission> nextPage(Page<SyncListPermission> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncListPermission> previousPage(Page<SyncListPermission> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<SyncListPermission> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncListPermission read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("permissions", response.getContent(), SyncListPermission.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

