/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.hostedNumbers;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.hostedNumbers.AuthorizationDocument;

public class AuthorizationDocumentReader
extends Reader<AuthorizationDocument> {
    private String email;
    private AuthorizationDocument.Status status;

    public AuthorizationDocumentReader setEmail(String email) {
        this.email = email;
        return this;
    }

    public AuthorizationDocumentReader setStatus(AuthorizationDocument.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public ResourceSet<AuthorizationDocument> read(TwilioRestClient client) {
        return new ResourceSet<AuthorizationDocument>(this, client, this.firstPage(client));
    }

    @Override
    public Page<AuthorizationDocument> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/HostedNumbers/AuthorizationDocuments");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AuthorizationDocument> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AuthorizationDocument> nextPage(Page<AuthorizationDocument> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AuthorizationDocument> previousPage(Page<AuthorizationDocument> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<AuthorizationDocument> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AuthorizationDocument read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("items", response.getContent(), AuthorizationDocument.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.email != null) {
            request.addQueryParam("Email", this.email);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

