/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.deployedDevices.fleet.Device;

public class DeviceUpdater
extends Updater<Device> {
    private final String pathFleetSid;
    private final String pathSid;
    private String friendlyName;
    private String identity;
    private String deploymentSid;
    private Boolean enabled;

    public DeviceUpdater(String pathFleetSid, String pathSid) {
        this.pathFleetSid = pathFleetSid;
        this.pathSid = pathSid;
    }

    public DeviceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public DeviceUpdater setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public DeviceUpdater setDeploymentSid(String deploymentSid) {
        this.deploymentSid = deploymentSid;
        return this;
    }

    public DeviceUpdater setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public Device update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/DeployedDevices/Fleets/" + this.pathFleetSid + "/Devices/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Device update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Device.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.deploymentSid != null) {
            request.addPostParam("DeploymentSid", this.deploymentSid);
        }
        if (this.enabled != null) {
            request.addPostParam("Enabled", this.enabled.toString());
        }
    }
}

