/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.deployedDevices.fleet.Certificate;

public class CertificateDeleter
extends Deleter<Certificate> {
    private final String pathFleetSid;
    private final String pathSid;

    public CertificateDeleter(String pathFleetSid, String pathSid) {
        this.pathFleetSid = pathFleetSid;
        this.pathSid = pathSid;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        Request request = new Request(HttpMethod.DELETE, Domains.PREVIEW.toString(), "/DeployedDevices/Fleets/" + this.pathFleetSid + "/Certificates/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Certificate delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return response.getStatusCode() == 204;
    }
}

