/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.bulkExports.export;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.bulkExports.export.DayFetcher;
import com.twilio.rest.preview.bulkExports.export.DayReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Day
extends Resource {
    private static final long serialVersionUID = 101410619433718L;
    private final URI redirectTo;
    private final String day;
    private final Integer size;
    private final String createDate;
    private final String friendlyName;
    private final String resourceType;

    public static DayFetcher fetcher(String pathResourceType, String pathDay) {
        return new DayFetcher(pathResourceType, pathDay);
    }

    public static DayReader reader(String pathResourceType) {
        return new DayReader(pathResourceType);
    }

    public static Day fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Day)objectMapper.readValue(json, Day.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Day fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Day)objectMapper.readValue(json, Day.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Day(@JsonProperty(value="redirect_to") URI redirectTo, @JsonProperty(value="day") String day, @JsonProperty(value="size") Integer size, @JsonProperty(value="create_date") String createDate, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="resource_type") String resourceType) {
        this.redirectTo = redirectTo;
        this.day = day;
        this.size = size;
        this.createDate = createDate;
        this.friendlyName = friendlyName;
        this.resourceType = resourceType;
    }

    public final URI getRedirectTo() {
        return this.redirectTo;
    }

    public final String getDay() {
        return this.day;
    }

    public final Integer getSize() {
        return this.size;
    }

    public final String getCreateDate() {
        return this.createDate;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getResourceType() {
        return this.resourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Day other = (Day)o;
        return Objects.equals(this.redirectTo, other.redirectTo) && Objects.equals(this.day, other.day) && Objects.equals(this.size, other.size) && Objects.equals(this.createDate, other.createDate) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.resourceType, other.resourceType);
    }

    public int hashCode() {
        return Objects.hash(this.redirectTo, this.day, this.size, this.createDate, this.friendlyName, this.resourceType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("redirectTo", (Object)this.redirectTo).add("day", (Object)this.day).add("size", (Object)this.size).add("createDate", (Object)this.createDate).add("friendlyName", (Object)this.friendlyName).add("resourceType", (Object)this.resourceType).toString();
    }
}

