/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance.bundle;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.ItemAssignment;

public class ItemAssignmentReader
extends Reader<ItemAssignment> {
    private final String pathBundleSid;

    public ItemAssignmentReader(String pathBundleSid) {
        this.pathBundleSid = pathBundleSid;
    }

    @Override
    public ResourceSet<ItemAssignment> read(TwilioRestClient client) {
        return new ResourceSet<ItemAssignment>(this, client, this.firstPage(client));
    }

    @Override
    public Page<ItemAssignment> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), "/v2/RegulatoryCompliance/Bundles/" + this.pathBundleSid + "/ItemAssignments");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ItemAssignment> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ItemAssignment> nextPage(Page<ItemAssignment> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ItemAssignment> previousPage(Page<ItemAssignment> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<ItemAssignment> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ItemAssignment read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("results", response.getContent(), ItemAssignment.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

