/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.SupportingDocument;
import java.util.Map;

public class SupportingDocumentCreator
extends Creator<SupportingDocument> {
    private final String friendlyName;
    private final String type;
    private Map<String, Object> attributes;

    public SupportingDocumentCreator(String friendlyName, String type) {
        this.friendlyName = friendlyName;
        this.type = type;
    }

    public SupportingDocumentCreator setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public SupportingDocument create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.NUMBERS.toString(), "/v2/RegulatoryCompliance/SupportingDocuments");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SupportingDocument creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return SupportingDocument.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.type != null) {
            request.addPostParam("Type", this.type);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", Converter.mapToJson(this.attributes));
        }
    }
}

