/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.EndUserType;

public class EndUserTypeFetcher
extends Fetcher<EndUserType> {
    private final String pathSid;

    public EndUserTypeFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public EndUserType fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), "/v2/RegulatoryCompliance/EndUserTypes/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("EndUserType fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return EndUserType.fromJson(response.getStream(), client.getObjectMapper());
    }
}

